/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRule;
import com.amazonaws.services.simplesystemsmanagement.model.PatchRuleGroup;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchRuleJsonMarshaller;

public class PatchRuleGroupJsonMarshaller {
    private static PatchRuleGroupJsonMarshaller instance;

    public void marshall(PatchRuleGroup patchRuleGroup, StructuredJsonGenerator jsonGenerator) {
        if (patchRuleGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList patchRulesList = (SdkInternalList)patchRuleGroup.getPatchRules();
            if (!patchRulesList.isEmpty() || !patchRulesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("PatchRules");
                jsonGenerator.writeStartArray();
                for (PatchRule patchRulesListValue : patchRulesList) {
                    if (patchRulesListValue == null) continue;
                    PatchRuleJsonMarshaller.getInstance().marshall(patchRulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PatchRuleGroupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PatchRuleGroupJsonMarshaller();
        }
        return instance;
    }
}

