/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryItemAttribute;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryItemSchema;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InventoryItemAttributeJsonMarshaller;

public class InventoryItemSchemaJsonMarshaller {
    private static InventoryItemSchemaJsonMarshaller instance;

    public void marshall(InventoryItemSchema inventoryItemSchema, StructuredJsonGenerator jsonGenerator) {
        if (inventoryItemSchema == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList attributesList;
            jsonGenerator.writeStartObject();
            if (inventoryItemSchema.getTypeName() != null) {
                jsonGenerator.writeFieldName("TypeName").writeValue(inventoryItemSchema.getTypeName());
            }
            if (inventoryItemSchema.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(inventoryItemSchema.getVersion());
            }
            if (!(attributesList = (SdkInternalList)inventoryItemSchema.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartArray();
                for (InventoryItemAttribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    InventoryItemAttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InventoryItemSchemaJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InventoryItemSchemaJsonMarshaller();
        }
        return instance;
    }
}

