/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.CreatePolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CreatePolicyVersionRequestMarshaller
implements Marshaller<Request<CreatePolicyVersionRequest>, CreatePolicyVersionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreatePolicyVersionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreatePolicyVersionRequest> marshall(CreatePolicyVersionRequest createPolicyVersionRequest) {
        if (createPolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePolicyVersionRequest> request = new DefaultRequest<CreatePolicyVersionRequest>(createPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/policies/{policyName}/version";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "policyName", createPolicyVersionRequest.getPolicyName());
        request.setResourcePath(uriResourcePath);
        if (createPolicyVersionRequest.getSetAsDefault() != null) {
            request.addParameter("setAsDefault", StringUtils.fromBoolean(createPolicyVersionRequest.getSetAsDefault()));
        }
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createPolicyVersionRequest.getPolicyDocument() != null) {
                jsonGenerator.writeFieldName("policyDocument").writeValue(createPolicyVersionRequest.getPolicyDocument());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

