/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AllocationStrategy;
import com.amazonaws.services.ec2.model.ExcessCapacityTerminationPolicy;
import com.amazonaws.services.ec2.model.FleetType;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SpotFleetRequestConfigData
implements Serializable,
Cloneable {
    private String clientToken;
    private String spotPrice;
    private Integer targetCapacity;
    private Date validFrom;
    private Date validUntil;
    private Boolean terminateInstancesWithExpiration;
    private String iamFleetRole;
    private SdkInternalList<SpotFleetLaunchSpecification> launchSpecifications;
    private String excessCapacityTerminationPolicy;
    private String allocationStrategy;
    private Double fulfilledCapacity;
    private String type;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public SpotFleetRequestConfigData withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
    }

    public String getSpotPrice() {
        return this.spotPrice;
    }

    public SpotFleetRequestConfigData withSpotPrice(String spotPrice) {
        this.setSpotPrice(spotPrice);
        return this;
    }

    public void setTargetCapacity(Integer targetCapacity) {
        this.targetCapacity = targetCapacity;
    }

    public Integer getTargetCapacity() {
        return this.targetCapacity;
    }

    public SpotFleetRequestConfigData withTargetCapacity(Integer targetCapacity) {
        this.setTargetCapacity(targetCapacity);
        return this;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public SpotFleetRequestConfigData withValidFrom(Date validFrom) {
        this.setValidFrom(validFrom);
        return this;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public SpotFleetRequestConfigData withValidUntil(Date validUntil) {
        this.setValidUntil(validUntil);
        return this;
    }

    public void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
    }

    public Boolean getTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public SpotFleetRequestConfigData withTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.setTerminateInstancesWithExpiration(terminateInstancesWithExpiration);
        return this;
    }

    public Boolean isTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public void setIamFleetRole(String iamFleetRole) {
        this.iamFleetRole = iamFleetRole;
    }

    public String getIamFleetRole() {
        return this.iamFleetRole;
    }

    public SpotFleetRequestConfigData withIamFleetRole(String iamFleetRole) {
        this.setIamFleetRole(iamFleetRole);
        return this;
    }

    public List<SpotFleetLaunchSpecification> getLaunchSpecifications() {
        if (this.launchSpecifications == null) {
            this.launchSpecifications = new SdkInternalList();
        }
        return this.launchSpecifications;
    }

    public void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
        if (launchSpecifications == null) {
            this.launchSpecifications = null;
            return;
        }
        this.launchSpecifications = new SdkInternalList<SpotFleetLaunchSpecification>(launchSpecifications);
    }

    public SpotFleetRequestConfigData withLaunchSpecifications(SpotFleetLaunchSpecification ... launchSpecifications) {
        if (this.launchSpecifications == null) {
            this.setLaunchSpecifications(new SdkInternalList<SpotFleetLaunchSpecification>(launchSpecifications.length));
        }
        for (SpotFleetLaunchSpecification ele : launchSpecifications) {
            this.launchSpecifications.add(ele);
        }
        return this;
    }

    public SpotFleetRequestConfigData withLaunchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
        this.setLaunchSpecifications(launchSpecifications);
        return this;
    }

    public void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
    }

    public String getExcessCapacityTerminationPolicy() {
        return this.excessCapacityTerminationPolicy;
    }

    public SpotFleetRequestConfigData withExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.setExcessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
        return this;
    }

    public void setExcessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy.toString();
    }

    public SpotFleetRequestConfigData withExcessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.setExcessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
        return this;
    }

    public void setAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public String getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public SpotFleetRequestConfigData withAllocationStrategy(String allocationStrategy) {
        this.setAllocationStrategy(allocationStrategy);
        return this;
    }

    public void setAllocationStrategy(AllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy.toString();
    }

    public SpotFleetRequestConfigData withAllocationStrategy(AllocationStrategy allocationStrategy) {
        this.setAllocationStrategy(allocationStrategy);
        return this;
    }

    public void setFulfilledCapacity(Double fulfilledCapacity) {
        this.fulfilledCapacity = fulfilledCapacity;
    }

    public Double getFulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public SpotFleetRequestConfigData withFulfilledCapacity(Double fulfilledCapacity) {
        this.setFulfilledCapacity(fulfilledCapacity);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public SpotFleetRequestConfigData withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(FleetType type) {
        this.type = type.toString();
    }

    public SpotFleetRequestConfigData withType(FleetType type) {
        this.setType(type);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getSpotPrice() != null) {
            sb.append("SpotPrice: ").append(this.getSpotPrice()).append(",");
        }
        if (this.getTargetCapacity() != null) {
            sb.append("TargetCapacity: ").append(this.getTargetCapacity()).append(",");
        }
        if (this.getValidFrom() != null) {
            sb.append("ValidFrom: ").append(this.getValidFrom()).append(",");
        }
        if (this.getValidUntil() != null) {
            sb.append("ValidUntil: ").append(this.getValidUntil()).append(",");
        }
        if (this.getTerminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: ").append(this.getTerminateInstancesWithExpiration()).append(",");
        }
        if (this.getIamFleetRole() != null) {
            sb.append("IamFleetRole: ").append(this.getIamFleetRole()).append(",");
        }
        if (this.getLaunchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.getLaunchSpecifications()).append(",");
        }
        if (this.getExcessCapacityTerminationPolicy() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(this.getExcessCapacityTerminationPolicy()).append(",");
        }
        if (this.getAllocationStrategy() != null) {
            sb.append("AllocationStrategy: ").append(this.getAllocationStrategy()).append(",");
        }
        if (this.getFulfilledCapacity() != null) {
            sb.append("FulfilledCapacity: ").append(this.getFulfilledCapacity()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getSpotPrice() == null ^ this.getSpotPrice() == null) {
            return false;
        }
        if (other.getSpotPrice() != null && !other.getSpotPrice().equals(this.getSpotPrice())) {
            return false;
        }
        if (other.getTargetCapacity() == null ^ this.getTargetCapacity() == null) {
            return false;
        }
        if (other.getTargetCapacity() != null && !other.getTargetCapacity().equals(this.getTargetCapacity())) {
            return false;
        }
        if (other.getValidFrom() == null ^ this.getValidFrom() == null) {
            return false;
        }
        if (other.getValidFrom() != null && !other.getValidFrom().equals(this.getValidFrom())) {
            return false;
        }
        if (other.getValidUntil() == null ^ this.getValidUntil() == null) {
            return false;
        }
        if (other.getValidUntil() != null && !other.getValidUntil().equals(this.getValidUntil())) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() == null ^ this.getTerminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() != null && !other.getTerminateInstancesWithExpiration().equals(this.getTerminateInstancesWithExpiration())) {
            return false;
        }
        if (other.getIamFleetRole() == null ^ this.getIamFleetRole() == null) {
            return false;
        }
        if (other.getIamFleetRole() != null && !other.getIamFleetRole().equals(this.getIamFleetRole())) {
            return false;
        }
        if (other.getLaunchSpecifications() == null ^ this.getLaunchSpecifications() == null) {
            return false;
        }
        if (other.getLaunchSpecifications() != null && !other.getLaunchSpecifications().equals(this.getLaunchSpecifications())) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() == null ^ this.getExcessCapacityTerminationPolicy() == null) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() != null && !other.getExcessCapacityTerminationPolicy().equals(this.getExcessCapacityTerminationPolicy())) {
            return false;
        }
        if (other.getAllocationStrategy() == null ^ this.getAllocationStrategy() == null) {
            return false;
        }
        if (other.getAllocationStrategy() != null && !other.getAllocationStrategy().equals(this.getAllocationStrategy())) {
            return false;
        }
        if (other.getFulfilledCapacity() == null ^ this.getFulfilledCapacity() == null) {
            return false;
        }
        if (other.getFulfilledCapacity() != null && !other.getFulfilledCapacity().equals(this.getFulfilledCapacity())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getSpotPrice() == null ? 0 : this.getSpotPrice().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacity() == null ? 0 : this.getTargetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getValidFrom() == null ? 0 : this.getValidFrom().hashCode());
        hashCode = 31 * hashCode + (this.getValidUntil() == null ? 0 : this.getValidUntil().hashCode());
        hashCode = 31 * hashCode + (this.getTerminateInstancesWithExpiration() == null ? 0 : this.getTerminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getIamFleetRole() == null ? 0 : this.getIamFleetRole().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecifications() == null ? 0 : this.getLaunchSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getExcessCapacityTerminationPolicy() == null ? 0 : this.getExcessCapacityTerminationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationStrategy() == null ? 0 : this.getAllocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getFulfilledCapacity() == null ? 0 : this.getFulfilledCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public SpotFleetRequestConfigData clone() {
        try {
            return (SpotFleetRequestConfigData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

