/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateDocumentationVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class CreateDocumentationVersionRequestMarshaller
implements Marshaller<Request<CreateDocumentationVersionRequest>, CreateDocumentationVersionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateDocumentationVersionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDocumentationVersionRequest> marshall(CreateDocumentationVersionRequest createDocumentationVersionRequest) {
        if (createDocumentationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDocumentationVersionRequest> request = new DefaultRequest<CreateDocumentationVersionRequest>(createDocumentationVersionRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/versions";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", createDocumentationVersionRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDocumentationVersionRequest.getDocumentationVersion() != null) {
                jsonGenerator.writeFieldName("documentationVersion").writeValue(createDocumentationVersionRequest.getDocumentationVersion());
            }
            if (createDocumentationVersionRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(createDocumentationVersionRequest.getStageName());
            }
            if (createDocumentationVersionRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createDocumentationVersionRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

