/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.SourceRegion;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeSourceRegionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private SdkInternalList<SourceRegion> sourceRegions;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeSourceRegionsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<SourceRegion> getSourceRegions() {
        if (this.sourceRegions == null) {
            this.sourceRegions = new SdkInternalList();
        }
        return this.sourceRegions;
    }

    public void setSourceRegions(Collection<SourceRegion> sourceRegions) {
        if (sourceRegions == null) {
            this.sourceRegions = null;
            return;
        }
        this.sourceRegions = new SdkInternalList<SourceRegion>(sourceRegions);
    }

    public DescribeSourceRegionsResult withSourceRegions(SourceRegion ... sourceRegions) {
        if (this.sourceRegions == null) {
            this.setSourceRegions(new SdkInternalList<SourceRegion>(sourceRegions.length));
        }
        for (SourceRegion ele : sourceRegions) {
            this.sourceRegions.add(ele);
        }
        return this;
    }

    public DescribeSourceRegionsResult withSourceRegions(Collection<SourceRegion> sourceRegions) {
        this.setSourceRegions(sourceRegions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getSourceRegions() != null) {
            sb.append("SourceRegions: ").append(this.getSourceRegions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceRegionsResult)) {
            return false;
        }
        DescribeSourceRegionsResult other = (DescribeSourceRegionsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getSourceRegions() == null ^ this.getSourceRegions() == null) {
            return false;
        }
        return other.getSourceRegions() == null || other.getSourceRegions().equals(this.getSourceRegions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getSourceRegions() == null ? 0 : this.getSourceRegions().hashCode());
        return hashCode;
    }

    public DescribeSourceRegionsResult clone() {
        try {
            return (DescribeSourceRegionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

