/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ListUsersInGroupRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListUsersInGroupRequestMarshaller
implements Marshaller<Request<ListUsersInGroupRequest>, ListUsersInGroupRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListUsersInGroupRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListUsersInGroupRequest> marshall(ListUsersInGroupRequest listUsersInGroupRequest) {
        if (listUsersInGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListUsersInGroupRequest> request = new DefaultRequest<ListUsersInGroupRequest>(listUsersInGroupRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ListUsersInGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listUsersInGroupRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(listUsersInGroupRequest.getUserPoolId());
            }
            if (listUsersInGroupRequest.getGroupName() != null) {
                jsonGenerator.writeFieldName("GroupName").writeValue(listUsersInGroupRequest.getGroupName());
            }
            if (listUsersInGroupRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listUsersInGroupRequest.getLimit());
            }
            if (listUsersInGroupRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listUsersInGroupRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

