/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.rekognition.AmazonRekognitionAsync;
import com.amazonaws.services.rekognition.AmazonRekognitionAsyncClientBuilder;
import com.amazonaws.services.rekognition.AmazonRekognitionClient;
import com.amazonaws.services.rekognition.model.CompareFacesRequest;
import com.amazonaws.services.rekognition.model.CompareFacesResult;
import com.amazonaws.services.rekognition.model.CreateCollectionRequest;
import com.amazonaws.services.rekognition.model.CreateCollectionResult;
import com.amazonaws.services.rekognition.model.DeleteCollectionRequest;
import com.amazonaws.services.rekognition.model.DeleteCollectionResult;
import com.amazonaws.services.rekognition.model.DeleteFacesRequest;
import com.amazonaws.services.rekognition.model.DeleteFacesResult;
import com.amazonaws.services.rekognition.model.DetectFacesRequest;
import com.amazonaws.services.rekognition.model.DetectFacesResult;
import com.amazonaws.services.rekognition.model.DetectLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectLabelsResult;
import com.amazonaws.services.rekognition.model.DetectModerationLabelsRequest;
import com.amazonaws.services.rekognition.model.DetectModerationLabelsResult;
import com.amazonaws.services.rekognition.model.DetectTextRequest;
import com.amazonaws.services.rekognition.model.DetectTextResult;
import com.amazonaws.services.rekognition.model.GetCelebrityInfoRequest;
import com.amazonaws.services.rekognition.model.GetCelebrityInfoResult;
import com.amazonaws.services.rekognition.model.IndexFacesRequest;
import com.amazonaws.services.rekognition.model.IndexFacesResult;
import com.amazonaws.services.rekognition.model.ListCollectionsRequest;
import com.amazonaws.services.rekognition.model.ListCollectionsResult;
import com.amazonaws.services.rekognition.model.ListFacesRequest;
import com.amazonaws.services.rekognition.model.ListFacesResult;
import com.amazonaws.services.rekognition.model.RecognizeCelebritiesRequest;
import com.amazonaws.services.rekognition.model.RecognizeCelebritiesResult;
import com.amazonaws.services.rekognition.model.SearchFacesByImageRequest;
import com.amazonaws.services.rekognition.model.SearchFacesByImageResult;
import com.amazonaws.services.rekognition.model.SearchFacesRequest;
import com.amazonaws.services.rekognition.model.SearchFacesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRekognitionAsyncClient
extends AmazonRekognitionClient
implements AmazonRekognitionAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonRekognitionAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRekognitionAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonRekognitionAsyncClientBuilder asyncBuilder() {
        return AmazonRekognitionAsyncClientBuilder.standard();
    }

    AmazonRekognitionAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CompareFacesResult> compareFacesAsync(CompareFacesRequest request) {
        return this.compareFacesAsync(request, null);
    }

    @Override
    public Future<CompareFacesResult> compareFacesAsync(CompareFacesRequest request, final AsyncHandler<CompareFacesRequest, CompareFacesResult> asyncHandler) {
        final CompareFacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CompareFacesResult>(){

            @Override
            public CompareFacesResult call() throws Exception {
                CompareFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeCompareFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request) {
        return this.createCollectionAsync(request, null);
    }

    @Override
    public Future<CreateCollectionResult> createCollectionAsync(CreateCollectionRequest request, final AsyncHandler<CreateCollectionRequest, CreateCollectionResult> asyncHandler) {
        final CreateCollectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCollectionResult>(){

            @Override
            public CreateCollectionResult call() throws Exception {
                CreateCollectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeCreateCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request) {
        return this.deleteCollectionAsync(request, null);
    }

    @Override
    public Future<DeleteCollectionResult> deleteCollectionAsync(DeleteCollectionRequest request, final AsyncHandler<DeleteCollectionRequest, DeleteCollectionResult> asyncHandler) {
        final DeleteCollectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCollectionResult>(){

            @Override
            public DeleteCollectionResult call() throws Exception {
                DeleteCollectionResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDeleteCollection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFacesResult> deleteFacesAsync(DeleteFacesRequest request) {
        return this.deleteFacesAsync(request, null);
    }

    @Override
    public Future<DeleteFacesResult> deleteFacesAsync(DeleteFacesRequest request, final AsyncHandler<DeleteFacesRequest, DeleteFacesResult> asyncHandler) {
        final DeleteFacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFacesResult>(){

            @Override
            public DeleteFacesResult call() throws Exception {
                DeleteFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDeleteFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectFacesResult> detectFacesAsync(DetectFacesRequest request) {
        return this.detectFacesAsync(request, null);
    }

    @Override
    public Future<DetectFacesResult> detectFacesAsync(DetectFacesRequest request, final AsyncHandler<DetectFacesRequest, DetectFacesResult> asyncHandler) {
        final DetectFacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectFacesResult>(){

            @Override
            public DetectFacesResult call() throws Exception {
                DetectFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectLabelsResult> detectLabelsAsync(DetectLabelsRequest request) {
        return this.detectLabelsAsync(request, null);
    }

    @Override
    public Future<DetectLabelsResult> detectLabelsAsync(DetectLabelsRequest request, final AsyncHandler<DetectLabelsRequest, DetectLabelsResult> asyncHandler) {
        final DetectLabelsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectLabelsResult>(){

            @Override
            public DetectLabelsResult call() throws Exception {
                DetectLabelsResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectLabels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectModerationLabelsResult> detectModerationLabelsAsync(DetectModerationLabelsRequest request) {
        return this.detectModerationLabelsAsync(request, null);
    }

    @Override
    public Future<DetectModerationLabelsResult> detectModerationLabelsAsync(DetectModerationLabelsRequest request, final AsyncHandler<DetectModerationLabelsRequest, DetectModerationLabelsResult> asyncHandler) {
        final DetectModerationLabelsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectModerationLabelsResult>(){

            @Override
            public DetectModerationLabelsResult call() throws Exception {
                DetectModerationLabelsResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectModerationLabels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectTextResult> detectTextAsync(DetectTextRequest request) {
        return this.detectTextAsync(request, null);
    }

    @Override
    public Future<DetectTextResult> detectTextAsync(DetectTextRequest request, final AsyncHandler<DetectTextRequest, DetectTextResult> asyncHandler) {
        final DetectTextRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectTextResult>(){

            @Override
            public DetectTextResult call() throws Exception {
                DetectTextResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeDetectText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCelebrityInfoResult> getCelebrityInfoAsync(GetCelebrityInfoRequest request) {
        return this.getCelebrityInfoAsync(request, null);
    }

    @Override
    public Future<GetCelebrityInfoResult> getCelebrityInfoAsync(GetCelebrityInfoRequest request, final AsyncHandler<GetCelebrityInfoRequest, GetCelebrityInfoResult> asyncHandler) {
        final GetCelebrityInfoRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCelebrityInfoResult>(){

            @Override
            public GetCelebrityInfoResult call() throws Exception {
                GetCelebrityInfoResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeGetCelebrityInfo(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<IndexFacesResult> indexFacesAsync(IndexFacesRequest request) {
        return this.indexFacesAsync(request, null);
    }

    @Override
    public Future<IndexFacesResult> indexFacesAsync(IndexFacesRequest request, final AsyncHandler<IndexFacesRequest, IndexFacesResult> asyncHandler) {
        final IndexFacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<IndexFacesResult>(){

            @Override
            public IndexFacesResult call() throws Exception {
                IndexFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeIndexFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request) {
        return this.listCollectionsAsync(request, null);
    }

    @Override
    public Future<ListCollectionsResult> listCollectionsAsync(ListCollectionsRequest request, final AsyncHandler<ListCollectionsRequest, ListCollectionsResult> asyncHandler) {
        final ListCollectionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCollectionsResult>(){

            @Override
            public ListCollectionsResult call() throws Exception {
                ListCollectionsResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeListCollections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFacesResult> listFacesAsync(ListFacesRequest request) {
        return this.listFacesAsync(request, null);
    }

    @Override
    public Future<ListFacesResult> listFacesAsync(ListFacesRequest request, final AsyncHandler<ListFacesRequest, ListFacesResult> asyncHandler) {
        final ListFacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFacesResult>(){

            @Override
            public ListFacesResult call() throws Exception {
                ListFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeListFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RecognizeCelebritiesResult> recognizeCelebritiesAsync(RecognizeCelebritiesRequest request) {
        return this.recognizeCelebritiesAsync(request, null);
    }

    @Override
    public Future<RecognizeCelebritiesResult> recognizeCelebritiesAsync(RecognizeCelebritiesRequest request, final AsyncHandler<RecognizeCelebritiesRequest, RecognizeCelebritiesResult> asyncHandler) {
        final RecognizeCelebritiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RecognizeCelebritiesResult>(){

            @Override
            public RecognizeCelebritiesResult call() throws Exception {
                RecognizeCelebritiesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeRecognizeCelebrities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFacesResult> searchFacesAsync(SearchFacesRequest request) {
        return this.searchFacesAsync(request, null);
    }

    @Override
    public Future<SearchFacesResult> searchFacesAsync(SearchFacesRequest request, final AsyncHandler<SearchFacesRequest, SearchFacesResult> asyncHandler) {
        final SearchFacesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchFacesResult>(){

            @Override
            public SearchFacesResult call() throws Exception {
                SearchFacesResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeSearchFaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchFacesByImageResult> searchFacesByImageAsync(SearchFacesByImageRequest request) {
        return this.searchFacesByImageAsync(request, null);
    }

    @Override
    public Future<SearchFacesByImageResult> searchFacesByImageAsync(SearchFacesByImageRequest request, final AsyncHandler<SearchFacesByImageRequest, SearchFacesByImageResult> asyncHandler) {
        final SearchFacesByImageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchFacesByImageResult>(){

            @Override
            public SearchFacesByImageResult call() throws Exception {
                SearchFacesByImageResult result = null;
                try {
                    result = AmazonRekognitionAsyncClient.this.executeSearchFacesByImage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

