/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Disk;
import com.amazonaws.services.lightsail.model.InstanceSnapshotState;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.transform.InstanceSnapshotMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class InstanceSnapshot
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String supportCode;
    private Date createdAt;
    private ResourceLocation location;
    private String resourceType;
    private String state;
    private String progress;
    private List<Disk> fromAttachedDisks;
    private String fromInstanceName;
    private String fromInstanceArn;
    private String fromBlueprintId;
    private String fromBundleId;
    private Integer sizeInGb;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InstanceSnapshot withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public InstanceSnapshot withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public InstanceSnapshot withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public InstanceSnapshot withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public InstanceSnapshot withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public InstanceSnapshot withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceType(ResourceType resourceType) {
        this.withResourceType(resourceType);
    }

    public InstanceSnapshot withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public InstanceSnapshot withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(InstanceSnapshotState state) {
        this.withState(state);
    }

    public InstanceSnapshot withState(InstanceSnapshotState state) {
        this.state = state.toString();
        return this;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public String getProgress() {
        return this.progress;
    }

    public InstanceSnapshot withProgress(String progress) {
        this.setProgress(progress);
        return this;
    }

    public List<Disk> getFromAttachedDisks() {
        return this.fromAttachedDisks;
    }

    public void setFromAttachedDisks(Collection<Disk> fromAttachedDisks) {
        if (fromAttachedDisks == null) {
            this.fromAttachedDisks = null;
            return;
        }
        this.fromAttachedDisks = new ArrayList<Disk>(fromAttachedDisks);
    }

    public InstanceSnapshot withFromAttachedDisks(Disk ... fromAttachedDisks) {
        if (this.fromAttachedDisks == null) {
            this.setFromAttachedDisks(new ArrayList<Disk>(fromAttachedDisks.length));
        }
        for (Disk ele : fromAttachedDisks) {
            this.fromAttachedDisks.add(ele);
        }
        return this;
    }

    public InstanceSnapshot withFromAttachedDisks(Collection<Disk> fromAttachedDisks) {
        this.setFromAttachedDisks(fromAttachedDisks);
        return this;
    }

    public void setFromInstanceName(String fromInstanceName) {
        this.fromInstanceName = fromInstanceName;
    }

    public String getFromInstanceName() {
        return this.fromInstanceName;
    }

    public InstanceSnapshot withFromInstanceName(String fromInstanceName) {
        this.setFromInstanceName(fromInstanceName);
        return this;
    }

    public void setFromInstanceArn(String fromInstanceArn) {
        this.fromInstanceArn = fromInstanceArn;
    }

    public String getFromInstanceArn() {
        return this.fromInstanceArn;
    }

    public InstanceSnapshot withFromInstanceArn(String fromInstanceArn) {
        this.setFromInstanceArn(fromInstanceArn);
        return this;
    }

    public void setFromBlueprintId(String fromBlueprintId) {
        this.fromBlueprintId = fromBlueprintId;
    }

    public String getFromBlueprintId() {
        return this.fromBlueprintId;
    }

    public InstanceSnapshot withFromBlueprintId(String fromBlueprintId) {
        this.setFromBlueprintId(fromBlueprintId);
        return this;
    }

    public void setFromBundleId(String fromBundleId) {
        this.fromBundleId = fromBundleId;
    }

    public String getFromBundleId() {
        return this.fromBundleId;
    }

    public InstanceSnapshot withFromBundleId(String fromBundleId) {
        this.setFromBundleId(fromBundleId);
        return this;
    }

    public void setSizeInGb(Integer sizeInGb) {
        this.sizeInGb = sizeInGb;
    }

    public Integer getSizeInGb() {
        return this.sizeInGb;
    }

    public InstanceSnapshot withSizeInGb(Integer sizeInGb) {
        this.setSizeInGb(sizeInGb);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getProgress() != null) {
            sb.append("Progress: ").append(this.getProgress()).append(",");
        }
        if (this.getFromAttachedDisks() != null) {
            sb.append("FromAttachedDisks: ").append(this.getFromAttachedDisks()).append(",");
        }
        if (this.getFromInstanceName() != null) {
            sb.append("FromInstanceName: ").append(this.getFromInstanceName()).append(",");
        }
        if (this.getFromInstanceArn() != null) {
            sb.append("FromInstanceArn: ").append(this.getFromInstanceArn()).append(",");
        }
        if (this.getFromBlueprintId() != null) {
            sb.append("FromBlueprintId: ").append(this.getFromBlueprintId()).append(",");
        }
        if (this.getFromBundleId() != null) {
            sb.append("FromBundleId: ").append(this.getFromBundleId()).append(",");
        }
        if (this.getSizeInGb() != null) {
            sb.append("SizeInGb: ").append(this.getSizeInGb());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSnapshot)) {
            return false;
        }
        InstanceSnapshot other = (InstanceSnapshot)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        if (other.getSupportCode() != null && !other.getSupportCode().equals(this.getSupportCode())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getProgress() == null ^ this.getProgress() == null) {
            return false;
        }
        if (other.getProgress() != null && !other.getProgress().equals(this.getProgress())) {
            return false;
        }
        if (other.getFromAttachedDisks() == null ^ this.getFromAttachedDisks() == null) {
            return false;
        }
        if (other.getFromAttachedDisks() != null && !other.getFromAttachedDisks().equals(this.getFromAttachedDisks())) {
            return false;
        }
        if (other.getFromInstanceName() == null ^ this.getFromInstanceName() == null) {
            return false;
        }
        if (other.getFromInstanceName() != null && !other.getFromInstanceName().equals(this.getFromInstanceName())) {
            return false;
        }
        if (other.getFromInstanceArn() == null ^ this.getFromInstanceArn() == null) {
            return false;
        }
        if (other.getFromInstanceArn() != null && !other.getFromInstanceArn().equals(this.getFromInstanceArn())) {
            return false;
        }
        if (other.getFromBlueprintId() == null ^ this.getFromBlueprintId() == null) {
            return false;
        }
        if (other.getFromBlueprintId() != null && !other.getFromBlueprintId().equals(this.getFromBlueprintId())) {
            return false;
        }
        if (other.getFromBundleId() == null ^ this.getFromBundleId() == null) {
            return false;
        }
        if (other.getFromBundleId() != null && !other.getFromBundleId().equals(this.getFromBundleId())) {
            return false;
        }
        if (other.getSizeInGb() == null ^ this.getSizeInGb() == null) {
            return false;
        }
        return other.getSizeInGb() == null || other.getSizeInGb().equals(this.getSizeInGb());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getProgress() == null ? 0 : this.getProgress().hashCode());
        hashCode = 31 * hashCode + (this.getFromAttachedDisks() == null ? 0 : this.getFromAttachedDisks().hashCode());
        hashCode = 31 * hashCode + (this.getFromInstanceName() == null ? 0 : this.getFromInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.getFromInstanceArn() == null ? 0 : this.getFromInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getFromBlueprintId() == null ? 0 : this.getFromBlueprintId().hashCode());
        hashCode = 31 * hashCode + (this.getFromBundleId() == null ? 0 : this.getFromBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getSizeInGb() == null ? 0 : this.getSizeInGb().hashCode());
        return hashCode;
    }

    public InstanceSnapshot clone() {
        try {
            return (InstanceSnapshot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

