/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.Device;
import com.amazonaws.services.ecs.model.KernelCapabilities;
import com.amazonaws.services.ecs.model.transform.LinuxParametersMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class LinuxParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private KernelCapabilities capabilities;
    private SdkInternalList<Device> devices;
    private Boolean initProcessEnabled;

    public void setCapabilities(KernelCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public KernelCapabilities getCapabilities() {
        return this.capabilities;
    }

    public LinuxParameters withCapabilities(KernelCapabilities capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public List<Device> getDevices() {
        if (this.devices == null) {
            this.devices = new SdkInternalList();
        }
        return this.devices;
    }

    public void setDevices(Collection<Device> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new SdkInternalList<Device>(devices);
    }

    public LinuxParameters withDevices(Device ... devices) {
        if (this.devices == null) {
            this.setDevices(new SdkInternalList<Device>(devices.length));
        }
        for (Device ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public LinuxParameters withDevices(Collection<Device> devices) {
        this.setDevices(devices);
        return this;
    }

    public void setInitProcessEnabled(Boolean initProcessEnabled) {
        this.initProcessEnabled = initProcessEnabled;
    }

    public Boolean getInitProcessEnabled() {
        return this.initProcessEnabled;
    }

    public LinuxParameters withInitProcessEnabled(Boolean initProcessEnabled) {
        this.setInitProcessEnabled(initProcessEnabled);
        return this;
    }

    public Boolean isInitProcessEnabled() {
        return this.initProcessEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getDevices() != null) {
            sb.append("Devices: ").append(this.getDevices()).append(",");
        }
        if (this.getInitProcessEnabled() != null) {
            sb.append("InitProcessEnabled: ").append(this.getInitProcessEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinuxParameters)) {
            return false;
        }
        LinuxParameters other = (LinuxParameters)obj;
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getInitProcessEnabled() == null ^ this.getInitProcessEnabled() == null) {
            return false;
        }
        return other.getInitProcessEnabled() == null || other.getInitProcessEnabled().equals(this.getInitProcessEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getInitProcessEnabled() == null ? 0 : this.getInitProcessEnabled().hashCode());
        return hashCode;
    }

    public LinuxParameters clone() {
        try {
            return (LinuxParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LinuxParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

