/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directory.model.DomainController;
import java.util.Date;

@SdkInternalApi
public class DomainControllerMarshaller {
    private static final MarshallingInfo<String> DIRECTORYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryId").build();
    private static final MarshallingInfo<String> DOMAINCONTROLLERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainControllerId").build();
    private static final MarshallingInfo<String> DNSIPADDR_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsIpAddr").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusReason").build();
    private static final MarshallingInfo<Date> LAUNCHTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchTime").build();
    private static final MarshallingInfo<Date> STATUSLASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusLastUpdatedDateTime").build();
    private static final DomainControllerMarshaller instance = new DomainControllerMarshaller();

    public static DomainControllerMarshaller getInstance() {
        return instance;
    }

    public void marshall(DomainController domainController, ProtocolMarshaller protocolMarshaller) {
        if (domainController == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(domainController.getDirectoryId(), DIRECTORYID_BINDING);
            protocolMarshaller.marshall(domainController.getDomainControllerId(), DOMAINCONTROLLERID_BINDING);
            protocolMarshaller.marshall(domainController.getDnsIpAddr(), DNSIPADDR_BINDING);
            protocolMarshaller.marshall(domainController.getVpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(domainController.getSubnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(domainController.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(domainController.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(domainController.getStatusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall(domainController.getLaunchTime(), LAUNCHTIME_BINDING);
            protocolMarshaller.marshall(domainController.getStatusLastUpdatedDateTime(), STATUSLASTUPDATEDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

