/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.AddressConfiguration;
import com.amazonaws.services.pinpoint.model.DirectMessageConfiguration;
import com.amazonaws.services.pinpoint.model.EndpointSendConfiguration;
import com.amazonaws.services.pinpoint.model.transform.MessageRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MessageRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, AddressConfiguration> addresses;
    private Map<String, String> context;
    private Map<String, EndpointSendConfiguration> endpoints;
    private DirectMessageConfiguration messageConfiguration;

    public Map<String, AddressConfiguration> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Map<String, AddressConfiguration> addresses) {
        this.addresses = addresses;
    }

    public MessageRequest withAddresses(Map<String, AddressConfiguration> addresses) {
        this.setAddresses(addresses);
        return this;
    }

    public MessageRequest addAddressesEntry(String key, AddressConfiguration value) {
        if (null == this.addresses) {
            this.addresses = new HashMap<String, AddressConfiguration>();
        }
        if (this.addresses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.addresses.put(key, value);
        return this;
    }

    public MessageRequest clearAddressesEntries() {
        this.addresses = null;
        return this;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public MessageRequest withContext(Map<String, String> context) {
        this.setContext(context);
        return this;
    }

    public MessageRequest addContextEntry(String key, String value) {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        if (this.context.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.context.put(key, value);
        return this;
    }

    public MessageRequest clearContextEntries() {
        this.context = null;
        return this;
    }

    public Map<String, EndpointSendConfiguration> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<String, EndpointSendConfiguration> endpoints) {
        this.endpoints = endpoints;
    }

    public MessageRequest withEndpoints(Map<String, EndpointSendConfiguration> endpoints) {
        this.setEndpoints(endpoints);
        return this;
    }

    public MessageRequest addEndpointsEntry(String key, EndpointSendConfiguration value) {
        if (null == this.endpoints) {
            this.endpoints = new HashMap<String, EndpointSendConfiguration>();
        }
        if (this.endpoints.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.endpoints.put(key, value);
        return this;
    }

    public MessageRequest clearEndpointsEntries() {
        this.endpoints = null;
        return this;
    }

    public void setMessageConfiguration(DirectMessageConfiguration messageConfiguration) {
        this.messageConfiguration = messageConfiguration;
    }

    public DirectMessageConfiguration getMessageConfiguration() {
        return this.messageConfiguration;
    }

    public MessageRequest withMessageConfiguration(DirectMessageConfiguration messageConfiguration) {
        this.setMessageConfiguration(messageConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddresses() != null) {
            sb.append("Addresses: ").append(this.getAddresses()).append(",");
        }
        if (this.getContext() != null) {
            sb.append("Context: ").append(this.getContext()).append(",");
        }
        if (this.getEndpoints() != null) {
            sb.append("Endpoints: ").append(this.getEndpoints()).append(",");
        }
        if (this.getMessageConfiguration() != null) {
            sb.append("MessageConfiguration: ").append(this.getMessageConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageRequest)) {
            return false;
        }
        MessageRequest other = (MessageRequest)obj;
        if (other.getAddresses() == null ^ this.getAddresses() == null) {
            return false;
        }
        if (other.getAddresses() != null && !other.getAddresses().equals(this.getAddresses())) {
            return false;
        }
        if (other.getContext() == null ^ this.getContext() == null) {
            return false;
        }
        if (other.getContext() != null && !other.getContext().equals(this.getContext())) {
            return false;
        }
        if (other.getEndpoints() == null ^ this.getEndpoints() == null) {
            return false;
        }
        if (other.getEndpoints() != null && !other.getEndpoints().equals(this.getEndpoints())) {
            return false;
        }
        if (other.getMessageConfiguration() == null ^ this.getMessageConfiguration() == null) {
            return false;
        }
        return other.getMessageConfiguration() == null || other.getMessageConfiguration().equals(this.getMessageConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddresses() == null ? 0 : this.getAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getContext() == null ? 0 : this.getContext().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoints() == null ? 0 : this.getEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getMessageConfiguration() == null ? 0 : this.getMessageConfiguration().hashCode());
        return hashCode;
    }

    public MessageRequest clone() {
        try {
            return (MessageRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

