/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticache.model.TestFailoverRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TestFailoverRequestMarshaller
implements Marshaller<Request<TestFailoverRequest>, TestFailoverRequest> {
    @Override
    public Request<TestFailoverRequest> marshall(TestFailoverRequest testFailoverRequest) {
        if (testFailoverRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestFailoverRequest> request = new DefaultRequest<TestFailoverRequest>(testFailoverRequest, "AmazonElastiCache");
        request.addParameter("Action", "TestFailover");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (testFailoverRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString(testFailoverRequest.getReplicationGroupId()));
        }
        if (testFailoverRequest.getNodeGroupId() != null) {
            request.addParameter("NodeGroupId", StringUtils.fromString(testFailoverRequest.getNodeGroupId()));
        }
        return request;
    }
}

