/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.MountPoint;

@SdkInternalApi
public class MountPointMarshaller {
    private static final MarshallingInfo<String> SOURCEVOLUME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVolume").build();
    private static final MarshallingInfo<String> CONTAINERPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerPath").build();
    private static final MarshallingInfo<Boolean> READONLY_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readOnly").build();
    private static final MountPointMarshaller instance = new MountPointMarshaller();

    public static MountPointMarshaller getInstance() {
        return instance;
    }

    public void marshall(MountPoint mountPoint, ProtocolMarshaller protocolMarshaller) {
        if (mountPoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(mountPoint.getSourceVolume(), SOURCEVOLUME_BINDING);
            protocolMarshaller.marshall(mountPoint.getContainerPath(), CONTAINERPATH_BINDING);
            protocolMarshaller.marshall(mountPoint.getReadOnly(), READONLY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

