/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.BulkEmailDestination;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.MessageTag;
import com.amazonaws.services.simpleemail.model.SendBulkTemplatedEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SendBulkTemplatedEmailRequestMarshaller
implements Marshaller<Request<SendBulkTemplatedEmailRequest>, SendBulkTemplatedEmailRequest> {
    @Override
    public Request<SendBulkTemplatedEmailRequest> marshall(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) {
        SdkInternalList destinationsList;
        SdkInternalList defaultTagsList;
        SdkInternalList replyToAddressesList;
        if (sendBulkTemplatedEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendBulkTemplatedEmailRequest> request = new DefaultRequest<SendBulkTemplatedEmailRequest>(sendBulkTemplatedEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendBulkTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendBulkTemplatedEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendBulkTemplatedEmailRequest.getSource()));
        }
        if (sendBulkTemplatedEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.getSourceArn()));
        }
        if (!(replyToAddressesList = (SdkInternalList)sendBulkTemplatedEmailRequest.getReplyToAddresses()).isEmpty() || !replyToAddressesList.isAutoConstruct()) {
            int replyToAddressesListIndex = 1;
            for (Object replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString((String)replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendBulkTemplatedEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendBulkTemplatedEmailRequest.getReturnPath()));
        }
        if (sendBulkTemplatedEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.getReturnPathArn()));
        }
        if (sendBulkTemplatedEmailRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendBulkTemplatedEmailRequest.getConfigurationSetName()));
        }
        if (!(defaultTagsList = (SdkInternalList)sendBulkTemplatedEmailRequest.getDefaultTags()).isEmpty() || !defaultTagsList.isAutoConstruct()) {
            int defaultTagsListIndex = 1;
            for (MessageTag defaultTagsListValue : defaultTagsList) {
                if (defaultTagsListValue.getName() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Name", StringUtils.fromString(defaultTagsListValue.getName()));
                }
                if (defaultTagsListValue.getValue() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Value", StringUtils.fromString(defaultTagsListValue.getValue()));
                }
                ++defaultTagsListIndex;
            }
        }
        if (sendBulkTemplatedEmailRequest.getTemplate() != null) {
            request.addParameter("Template", StringUtils.fromString(sendBulkTemplatedEmailRequest.getTemplate()));
        }
        if (sendBulkTemplatedEmailRequest.getTemplateArn() != null) {
            request.addParameter("TemplateArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.getTemplateArn()));
        }
        if (sendBulkTemplatedEmailRequest.getDefaultTemplateData() != null) {
            request.addParameter("DefaultTemplateData", StringUtils.fromString(sendBulkTemplatedEmailRequest.getDefaultTemplateData()));
        }
        if (!(destinationsList = (SdkInternalList)sendBulkTemplatedEmailRequest.getDestinations()).isEmpty() || !destinationsList.isAutoConstruct()) {
            int destinationsListIndex = 1;
            for (BulkEmailDestination destinationsListValue : destinationsList) {
                SdkInternalList replacementTagsList;
                Destination destination = destinationsListValue.getDestination();
                if (destination != null) {
                    SdkInternalList bccAddressesList;
                    SdkInternalList ccAddressesList;
                    SdkInternalList toAddressesList = (SdkInternalList)destination.getToAddresses();
                    if (!toAddressesList.isEmpty() || !toAddressesList.isAutoConstruct()) {
                        int toAddressesListIndex = 1;
                        for (Object toAddressesListValue : toAddressesList) {
                            if (toAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString((String)toAddressesListValue));
                            }
                            ++toAddressesListIndex;
                        }
                    }
                    if (!(ccAddressesList = (SdkInternalList)destination.getCcAddresses()).isEmpty() || !ccAddressesList.isAutoConstruct()) {
                        Object toAddressesListValue;
                        int ccAddressesListIndex = 1;
                        toAddressesListValue = ccAddressesList.iterator();
                        while (toAddressesListValue.hasNext()) {
                            String ccAddressesListValue = (String)toAddressesListValue.next();
                            if (ccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString(ccAddressesListValue));
                            }
                            ++ccAddressesListIndex;
                        }
                    }
                    if (!(bccAddressesList = (SdkInternalList)destination.getBccAddresses()).isEmpty() || !bccAddressesList.isAutoConstruct()) {
                        int bccAddressesListIndex = 1;
                        for (String bccAddressesListValue : bccAddressesList) {
                            if (bccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString(bccAddressesListValue));
                            }
                            ++bccAddressesListIndex;
                        }
                    }
                }
                if (!(replacementTagsList = (SdkInternalList)destinationsListValue.getReplacementTags()).isEmpty() || !replacementTagsList.isAutoConstruct()) {
                    int replacementTagsListIndex = 1;
                    for (MessageTag replacementTagsListValue : replacementTagsList) {
                        if (replacementTagsListValue.getName() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Name", StringUtils.fromString(replacementTagsListValue.getName()));
                        }
                        if (replacementTagsListValue.getValue() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Value", StringUtils.fromString(replacementTagsListValue.getValue()));
                        }
                        ++replacementTagsListIndex;
                    }
                }
                if (destinationsListValue.getReplacementTemplateData() != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTemplateData", StringUtils.fromString(destinationsListValue.getReplacementTemplateData()));
                }
                ++destinationsListIndex;
            }
        }
        return request;
    }
}

