/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.TargetTrackingConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ScalingPolicy
implements Serializable,
Cloneable {
    private String autoScalingGroupName;
    private String policyName;
    private String policyARN;
    private String policyType;
    private String adjustmentType;
    private Integer minAdjustmentStep;
    private Integer minAdjustmentMagnitude;
    private Integer scalingAdjustment;
    private Integer cooldown;
    private SdkInternalList<StepAdjustment> stepAdjustments;
    private String metricAggregationType;
    private Integer estimatedInstanceWarmup;
    private SdkInternalList<Alarm> alarms;
    private TargetTrackingConfiguration targetTrackingConfiguration;

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public ScalingPolicy withAutoScalingGroupName(String autoScalingGroupName) {
        this.setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public ScalingPolicy withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public void setPolicyARN(String policyARN) {
        this.policyARN = policyARN;
    }

    public String getPolicyARN() {
        return this.policyARN;
    }

    public ScalingPolicy withPolicyARN(String policyARN) {
        this.setPolicyARN(policyARN);
        return this;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public ScalingPolicy withPolicyType(String policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    public void setAdjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public String getAdjustmentType() {
        return this.adjustmentType;
    }

    public ScalingPolicy withAdjustmentType(String adjustmentType) {
        this.setAdjustmentType(adjustmentType);
        return this;
    }

    public void setMinAdjustmentStep(Integer minAdjustmentStep) {
        this.minAdjustmentStep = minAdjustmentStep;
    }

    public Integer getMinAdjustmentStep() {
        return this.minAdjustmentStep;
    }

    public ScalingPolicy withMinAdjustmentStep(Integer minAdjustmentStep) {
        this.setMinAdjustmentStep(minAdjustmentStep);
        return this;
    }

    public void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
        this.minAdjustmentMagnitude = minAdjustmentMagnitude;
    }

    public Integer getMinAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public ScalingPolicy withMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
        this.setMinAdjustmentMagnitude(minAdjustmentMagnitude);
        return this;
    }

    public void setScalingAdjustment(Integer scalingAdjustment) {
        this.scalingAdjustment = scalingAdjustment;
    }

    public Integer getScalingAdjustment() {
        return this.scalingAdjustment;
    }

    public ScalingPolicy withScalingAdjustment(Integer scalingAdjustment) {
        this.setScalingAdjustment(scalingAdjustment);
        return this;
    }

    public void setCooldown(Integer cooldown) {
        this.cooldown = cooldown;
    }

    public Integer getCooldown() {
        return this.cooldown;
    }

    public ScalingPolicy withCooldown(Integer cooldown) {
        this.setCooldown(cooldown);
        return this;
    }

    public List<StepAdjustment> getStepAdjustments() {
        if (this.stepAdjustments == null) {
            this.stepAdjustments = new SdkInternalList();
        }
        return this.stepAdjustments;
    }

    public void setStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
        if (stepAdjustments == null) {
            this.stepAdjustments = null;
            return;
        }
        this.stepAdjustments = new SdkInternalList<StepAdjustment>(stepAdjustments);
    }

    public ScalingPolicy withStepAdjustments(StepAdjustment ... stepAdjustments) {
        if (this.stepAdjustments == null) {
            this.setStepAdjustments(new SdkInternalList<StepAdjustment>(stepAdjustments.length));
        }
        for (StepAdjustment ele : stepAdjustments) {
            this.stepAdjustments.add(ele);
        }
        return this;
    }

    public ScalingPolicy withStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
        this.setStepAdjustments(stepAdjustments);
        return this;
    }

    public void setMetricAggregationType(String metricAggregationType) {
        this.metricAggregationType = metricAggregationType;
    }

    public String getMetricAggregationType() {
        return this.metricAggregationType;
    }

    public ScalingPolicy withMetricAggregationType(String metricAggregationType) {
        this.setMetricAggregationType(metricAggregationType);
        return this;
    }

    public void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
        this.estimatedInstanceWarmup = estimatedInstanceWarmup;
    }

    public Integer getEstimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public ScalingPolicy withEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
        this.setEstimatedInstanceWarmup(estimatedInstanceWarmup);
        return this;
    }

    public List<Alarm> getAlarms() {
        if (this.alarms == null) {
            this.alarms = new SdkInternalList();
        }
        return this.alarms;
    }

    public void setAlarms(Collection<Alarm> alarms) {
        if (alarms == null) {
            this.alarms = null;
            return;
        }
        this.alarms = new SdkInternalList<Alarm>(alarms);
    }

    public ScalingPolicy withAlarms(Alarm ... alarms) {
        if (this.alarms == null) {
            this.setAlarms(new SdkInternalList<Alarm>(alarms.length));
        }
        for (Alarm ele : alarms) {
            this.alarms.add(ele);
        }
        return this;
    }

    public ScalingPolicy withAlarms(Collection<Alarm> alarms) {
        this.setAlarms(alarms);
        return this;
    }

    public void setTargetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
        this.targetTrackingConfiguration = targetTrackingConfiguration;
    }

    public TargetTrackingConfiguration getTargetTrackingConfiguration() {
        return this.targetTrackingConfiguration;
    }

    public ScalingPolicy withTargetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
        this.setTargetTrackingConfiguration(targetTrackingConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.getAutoScalingGroupName()).append(",");
        }
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getPolicyARN() != null) {
            sb.append("PolicyARN: ").append(this.getPolicyARN()).append(",");
        }
        if (this.getPolicyType() != null) {
            sb.append("PolicyType: ").append(this.getPolicyType()).append(",");
        }
        if (this.getAdjustmentType() != null) {
            sb.append("AdjustmentType: ").append(this.getAdjustmentType()).append(",");
        }
        if (this.getMinAdjustmentStep() != null) {
            sb.append("MinAdjustmentStep: ").append(this.getMinAdjustmentStep()).append(",");
        }
        if (this.getMinAdjustmentMagnitude() != null) {
            sb.append("MinAdjustmentMagnitude: ").append(this.getMinAdjustmentMagnitude()).append(",");
        }
        if (this.getScalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(this.getScalingAdjustment()).append(",");
        }
        if (this.getCooldown() != null) {
            sb.append("Cooldown: ").append(this.getCooldown()).append(",");
        }
        if (this.getStepAdjustments() != null) {
            sb.append("StepAdjustments: ").append(this.getStepAdjustments()).append(",");
        }
        if (this.getMetricAggregationType() != null) {
            sb.append("MetricAggregationType: ").append(this.getMetricAggregationType()).append(",");
        }
        if (this.getEstimatedInstanceWarmup() != null) {
            sb.append("EstimatedInstanceWarmup: ").append(this.getEstimatedInstanceWarmup()).append(",");
        }
        if (this.getAlarms() != null) {
            sb.append("Alarms: ").append(this.getAlarms()).append(",");
        }
        if (this.getTargetTrackingConfiguration() != null) {
            sb.append("TargetTrackingConfiguration: ").append(this.getTargetTrackingConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getPolicyARN() == null ^ this.getPolicyARN() == null) {
            return false;
        }
        if (other.getPolicyARN() != null && !other.getPolicyARN().equals(this.getPolicyARN())) {
            return false;
        }
        if (other.getPolicyType() == null ^ this.getPolicyType() == null) {
            return false;
        }
        if (other.getPolicyType() != null && !other.getPolicyType().equals(this.getPolicyType())) {
            return false;
        }
        if (other.getAdjustmentType() == null ^ this.getAdjustmentType() == null) {
            return false;
        }
        if (other.getAdjustmentType() != null && !other.getAdjustmentType().equals(this.getAdjustmentType())) {
            return false;
        }
        if (other.getMinAdjustmentStep() == null ^ this.getMinAdjustmentStep() == null) {
            return false;
        }
        if (other.getMinAdjustmentStep() != null && !other.getMinAdjustmentStep().equals(this.getMinAdjustmentStep())) {
            return false;
        }
        if (other.getMinAdjustmentMagnitude() == null ^ this.getMinAdjustmentMagnitude() == null) {
            return false;
        }
        if (other.getMinAdjustmentMagnitude() != null && !other.getMinAdjustmentMagnitude().equals(this.getMinAdjustmentMagnitude())) {
            return false;
        }
        if (other.getScalingAdjustment() == null ^ this.getScalingAdjustment() == null) {
            return false;
        }
        if (other.getScalingAdjustment() != null && !other.getScalingAdjustment().equals(this.getScalingAdjustment())) {
            return false;
        }
        if (other.getCooldown() == null ^ this.getCooldown() == null) {
            return false;
        }
        if (other.getCooldown() != null && !other.getCooldown().equals(this.getCooldown())) {
            return false;
        }
        if (other.getStepAdjustments() == null ^ this.getStepAdjustments() == null) {
            return false;
        }
        if (other.getStepAdjustments() != null && !other.getStepAdjustments().equals(this.getStepAdjustments())) {
            return false;
        }
        if (other.getMetricAggregationType() == null ^ this.getMetricAggregationType() == null) {
            return false;
        }
        if (other.getMetricAggregationType() != null && !other.getMetricAggregationType().equals(this.getMetricAggregationType())) {
            return false;
        }
        if (other.getEstimatedInstanceWarmup() == null ^ this.getEstimatedInstanceWarmup() == null) {
            return false;
        }
        if (other.getEstimatedInstanceWarmup() != null && !other.getEstimatedInstanceWarmup().equals(this.getEstimatedInstanceWarmup())) {
            return false;
        }
        if (other.getAlarms() == null ^ this.getAlarms() == null) {
            return false;
        }
        if (other.getAlarms() != null && !other.getAlarms().equals(this.getAlarms())) {
            return false;
        }
        if (other.getTargetTrackingConfiguration() == null ^ this.getTargetTrackingConfiguration() == null) {
            return false;
        }
        return other.getTargetTrackingConfiguration() == null || other.getTargetTrackingConfiguration().equals(this.getTargetTrackingConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyARN() == null ? 0 : this.getPolicyARN().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyType() == null ? 0 : this.getPolicyType().hashCode());
        hashCode = 31 * hashCode + (this.getAdjustmentType() == null ? 0 : this.getAdjustmentType().hashCode());
        hashCode = 31 * hashCode + (this.getMinAdjustmentStep() == null ? 0 : this.getMinAdjustmentStep().hashCode());
        hashCode = 31 * hashCode + (this.getMinAdjustmentMagnitude() == null ? 0 : this.getMinAdjustmentMagnitude().hashCode());
        hashCode = 31 * hashCode + (this.getScalingAdjustment() == null ? 0 : this.getScalingAdjustment().hashCode());
        hashCode = 31 * hashCode + (this.getCooldown() == null ? 0 : this.getCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getStepAdjustments() == null ? 0 : this.getStepAdjustments().hashCode());
        hashCode = 31 * hashCode + (this.getMetricAggregationType() == null ? 0 : this.getMetricAggregationType().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedInstanceWarmup() == null ? 0 : this.getEstimatedInstanceWarmup().hashCode());
        hashCode = 31 * hashCode + (this.getAlarms() == null ? 0 : this.getAlarms().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTrackingConfiguration() == null ? 0 : this.getTargetTrackingConfiguration().hashCode());
        return hashCode;
    }

    public ScalingPolicy clone() {
        try {
            return (ScalingPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

