/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.RequestMetricType;
import com.amazonaws.metrics.internal.cloudwatch.PredefinedMetricTransformer;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.concurrent.BlockingQueue;

@ThreadSafe
public class RequestMetricCollectorSupport
extends RequestMetricCollector {
    protected static final Log log = LogFactory.getLog(RequestMetricCollectorSupport.class);
    private final BlockingQueue<MetricDatum> queue;
    private final PredefinedMetricTransformer transformer = new PredefinedMetricTransformer();

    protected RequestMetricCollectorSupport(BlockingQueue<MetricDatum> queue) {
        this.queue = queue;
    }

    @Override
    public void collectMetrics(Request<?> request, Response<?> response) {
        block2: {
            try {
                this.collectMetrics0(request, response);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Ignoring unexpected failure", ex);
            }
        }
    }

    private void collectMetrics0(Request<?> request, Response<?> response) {
        AWSRequestMetrics arm = request.getAWSRequestMetrics();
        if (arm == null || !arm.isEnabled()) {
            return;
        }
        for (MetricType type : AwsSdkMetrics.getPredefinedMetrics()) {
            if (!(type instanceof RequestMetricType)) continue;
            PredefinedMetricTransformer transformer = this.getTransformer();
            for (MetricDatum datum : transformer.toMetricData(type, request, response)) {
                try {
                    if (this.addMetricsToQueue(datum) || !log.isDebugEnabled()) continue;
                    log.debug("Failed to add to the metrics queue (due to no space available) for " + type.name() + ":" + request.getServiceName());
                }
                catch (RuntimeException ex) {
                    log.warn("Failed to add to the metrics queue for " + type.name() + ":" + request.getServiceName(), ex);
                }
            }
        }
    }

    protected boolean addMetricsToQueue(MetricDatum metric) {
        return this.queue.offer(metric);
    }

    protected PredefinedMetricTransformer getTransformer() {
        return this.transformer;
    }
}

