/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentHashType;
import com.amazonaws.services.simplesystemsmanagement.model.NotificationConfig;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SendCommandRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> instanceIds;
    private SdkInternalList<Target> targets;
    private String documentName;
    private String documentHash;
    private String documentHashType;
    private Integer timeoutSeconds;
    private String comment;
    private Map<String, List<String>> parameters;
    private String outputS3Region;
    private String outputS3BucketName;
    private String outputS3KeyPrefix;
    private String maxConcurrency;
    private String maxErrors;
    private String serviceRoleArn;
    private NotificationConfig notificationConfig;

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new SdkInternalList();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new SdkInternalList<String>(instanceIds);
    }

    public SendCommandRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds(new SdkInternalList<String>(instanceIds.length));
        }
        for (String ele : instanceIds) {
            this.instanceIds.add(ele);
        }
        return this;
    }

    public SendCommandRequest withInstanceIds(Collection<String> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList<Target>(targets);
    }

    public SendCommandRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new SdkInternalList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public SendCommandRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public SendCommandRequest withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setDocumentHash(String documentHash) {
        this.documentHash = documentHash;
    }

    public String getDocumentHash() {
        return this.documentHash;
    }

    public SendCommandRequest withDocumentHash(String documentHash) {
        this.setDocumentHash(documentHash);
        return this;
    }

    public void setDocumentHashType(String documentHashType) {
        this.documentHashType = documentHashType;
    }

    @JsonProperty(value="documentHashType")
    public String getDocumentHashType() {
        return this.documentHashType;
    }

    public SendCommandRequest withDocumentHashType(String documentHashType) {
        this.setDocumentHashType(documentHashType);
        return this;
    }

    @JsonIgnore
    public void setDocumentHashType(DocumentHashType documentHashType) {
        this.withDocumentHashType(documentHashType);
    }

    public SendCommandRequest withDocumentHashType(DocumentHashType documentHashType) {
        this.documentHashType = documentHashType.toString();
        return this;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public SendCommandRequest withTimeoutSeconds(Integer timeoutSeconds) {
        this.setTimeoutSeconds(timeoutSeconds);
        return this;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public SendCommandRequest withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public SendCommandRequest withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public SendCommandRequest addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public SendCommandRequest clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setOutputS3Region(String outputS3Region) {
        this.outputS3Region = outputS3Region;
    }

    public String getOutputS3Region() {
        return this.outputS3Region;
    }

    public SendCommandRequest withOutputS3Region(String outputS3Region) {
        this.setOutputS3Region(outputS3Region);
        return this;
    }

    public void setOutputS3BucketName(String outputS3BucketName) {
        this.outputS3BucketName = outputS3BucketName;
    }

    public String getOutputS3BucketName() {
        return this.outputS3BucketName;
    }

    public SendCommandRequest withOutputS3BucketName(String outputS3BucketName) {
        this.setOutputS3BucketName(outputS3BucketName);
        return this;
    }

    public void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
        this.outputS3KeyPrefix = outputS3KeyPrefix;
    }

    public String getOutputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public SendCommandRequest withOutputS3KeyPrefix(String outputS3KeyPrefix) {
        this.setOutputS3KeyPrefix(outputS3KeyPrefix);
        return this;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public SendCommandRequest withMaxConcurrency(String maxConcurrency) {
        this.setMaxConcurrency(maxConcurrency);
        return this;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public SendCommandRequest withMaxErrors(String maxErrors) {
        this.setMaxErrors(maxErrors);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public SendCommandRequest withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public void setNotificationConfig(NotificationConfig notificationConfig) {
        this.notificationConfig = notificationConfig;
    }

    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    public SendCommandRequest withNotificationConfig(NotificationConfig notificationConfig) {
        this.setNotificationConfig(notificationConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: ").append(this.getInstanceIds()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: ").append(this.getDocumentName()).append(",");
        }
        if (this.getDocumentHash() != null) {
            sb.append("DocumentHash: ").append(this.getDocumentHash()).append(",");
        }
        if (this.getDocumentHashType() != null) {
            sb.append("DocumentHashType: ").append(this.getDocumentHashType()).append(",");
        }
        if (this.getTimeoutSeconds() != null) {
            sb.append("TimeoutSeconds: ").append(this.getTimeoutSeconds()).append(",");
        }
        if (this.getComment() != null) {
            sb.append("Comment: ").append(this.getComment()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getOutputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.getOutputS3Region()).append(",");
        }
        if (this.getOutputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.getOutputS3BucketName()).append(",");
        }
        if (this.getOutputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.getOutputS3KeyPrefix()).append(",");
        }
        if (this.getMaxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.getMaxConcurrency()).append(",");
        }
        if (this.getMaxErrors() != null) {
            sb.append("MaxErrors: ").append(this.getMaxErrors()).append(",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.getServiceRoleArn()).append(",");
        }
        if (this.getNotificationConfig() != null) {
            sb.append("NotificationConfig: ").append(this.getNotificationConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest)obj;
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getDocumentHash() == null ^ this.getDocumentHash() == null) {
            return false;
        }
        if (other.getDocumentHash() != null && !other.getDocumentHash().equals(this.getDocumentHash())) {
            return false;
        }
        if (other.getDocumentHashType() == null ^ this.getDocumentHashType() == null) {
            return false;
        }
        if (other.getDocumentHashType() != null && !other.getDocumentHashType().equals(this.getDocumentHashType())) {
            return false;
        }
        if (other.getTimeoutSeconds() == null ^ this.getTimeoutSeconds() == null) {
            return false;
        }
        if (other.getTimeoutSeconds() != null && !other.getTimeoutSeconds().equals(this.getTimeoutSeconds())) {
            return false;
        }
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getOutputS3Region() == null ^ this.getOutputS3Region() == null) {
            return false;
        }
        if (other.getOutputS3Region() != null && !other.getOutputS3Region().equals(this.getOutputS3Region())) {
            return false;
        }
        if (other.getOutputS3BucketName() == null ^ this.getOutputS3BucketName() == null) {
            return false;
        }
        if (other.getOutputS3BucketName() != null && !other.getOutputS3BucketName().equals(this.getOutputS3BucketName())) {
            return false;
        }
        if (other.getOutputS3KeyPrefix() == null ^ this.getOutputS3KeyPrefix() == null) {
            return false;
        }
        if (other.getOutputS3KeyPrefix() != null && !other.getOutputS3KeyPrefix().equals(this.getOutputS3KeyPrefix())) {
            return false;
        }
        if (other.getMaxConcurrency() == null ^ this.getMaxConcurrency() == null) {
            return false;
        }
        if (other.getMaxConcurrency() != null && !other.getMaxConcurrency().equals(this.getMaxConcurrency())) {
            return false;
        }
        if (other.getMaxErrors() == null ^ this.getMaxErrors() == null) {
            return false;
        }
        if (other.getMaxErrors() != null && !other.getMaxErrors().equals(this.getMaxErrors())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getNotificationConfig() == null ^ this.getNotificationConfig() == null) {
            return false;
        }
        return other.getNotificationConfig() == null || other.getNotificationConfig().equals(this.getNotificationConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentHash() == null ? 0 : this.getDocumentHash().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentHashType() == null ? 0 : this.getDocumentHashType().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutSeconds() == null ? 0 : this.getTimeoutSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3Region() == null ? 0 : this.getOutputS3Region().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3BucketName() == null ? 0 : this.getOutputS3BucketName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3KeyPrefix() == null ? 0 : this.getOutputS3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrency() == null ? 0 : this.getMaxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.getMaxErrors() == null ? 0 : this.getMaxErrors().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationConfig() == null ? 0 : this.getNotificationConfig().hashCode());
        return hashCode;
    }

    @Override
    public SendCommandRequest clone() {
        return (SendCommandRequest)super.clone();
    }
}

