/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisfirehose.model.BufferingHints;
import com.amazonaws.services.kinesisfirehose.model.CloudWatchLoggingOptions;
import com.amazonaws.services.kinesisfirehose.model.CompressionFormat;
import com.amazonaws.services.kinesisfirehose.model.EncryptionConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class S3DestinationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String roleARN;
    private String bucketARN;
    private String prefix;
    private BufferingHints bufferingHints;
    private String compressionFormat;
    private EncryptionConfiguration encryptionConfiguration;
    private CloudWatchLoggingOptions cloudWatchLoggingOptions;

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public S3DestinationConfiguration withRoleARN(String roleARN) {
        this.setRoleARN(roleARN);
        return this;
    }

    public void setBucketARN(String bucketARN) {
        this.bucketARN = bucketARN;
    }

    public String getBucketARN() {
        return this.bucketARN;
    }

    public S3DestinationConfiguration withBucketARN(String bucketARN) {
        this.setBucketARN(bucketARN);
        return this;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public S3DestinationConfiguration withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public void setBufferingHints(BufferingHints bufferingHints) {
        this.bufferingHints = bufferingHints;
    }

    public BufferingHints getBufferingHints() {
        return this.bufferingHints;
    }

    public S3DestinationConfiguration withBufferingHints(BufferingHints bufferingHints) {
        this.setBufferingHints(bufferingHints);
        return this;
    }

    public void setCompressionFormat(String compressionFormat) {
        this.compressionFormat = compressionFormat;
    }

    @JsonProperty(value="compressionFormat")
    public String getCompressionFormat() {
        return this.compressionFormat;
    }

    public S3DestinationConfiguration withCompressionFormat(String compressionFormat) {
        this.setCompressionFormat(compressionFormat);
        return this;
    }

    @JsonIgnore
    public void setCompressionFormat(CompressionFormat compressionFormat) {
        this.withCompressionFormat(compressionFormat);
    }

    public S3DestinationConfiguration withCompressionFormat(CompressionFormat compressionFormat) {
        this.compressionFormat = compressionFormat.toString();
        return this;
    }

    public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public S3DestinationConfiguration withEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
        this.setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    public void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
        this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
    }

    public CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public S3DestinationConfiguration withCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
        this.setCloudWatchLoggingOptions(cloudWatchLoggingOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleARN() != null) {
            sb.append("RoleARN: ").append(this.getRoleARN()).append(",");
        }
        if (this.getBucketARN() != null) {
            sb.append("BucketARN: ").append(this.getBucketARN()).append(",");
        }
        if (this.getPrefix() != null) {
            sb.append("Prefix: ").append(this.getPrefix()).append(",");
        }
        if (this.getBufferingHints() != null) {
            sb.append("BufferingHints: ").append(this.getBufferingHints()).append(",");
        }
        if (this.getCompressionFormat() != null) {
            sb.append("CompressionFormat: ").append(this.getCompressionFormat()).append(",");
        }
        if (this.getEncryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.getEncryptionConfiguration()).append(",");
        }
        if (this.getCloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.getCloudWatchLoggingOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfiguration)) {
            return false;
        }
        S3DestinationConfiguration other = (S3DestinationConfiguration)obj;
        if (other.getRoleARN() == null ^ this.getRoleARN() == null) {
            return false;
        }
        if (other.getRoleARN() != null && !other.getRoleARN().equals(this.getRoleARN())) {
            return false;
        }
        if (other.getBucketARN() == null ^ this.getBucketARN() == null) {
            return false;
        }
        if (other.getBucketARN() != null && !other.getBucketARN().equals(this.getBucketARN())) {
            return false;
        }
        if (other.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (other.getPrefix() != null && !other.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (other.getBufferingHints() == null ^ this.getBufferingHints() == null) {
            return false;
        }
        if (other.getBufferingHints() != null && !other.getBufferingHints().equals(this.getBufferingHints())) {
            return false;
        }
        if (other.getCompressionFormat() == null ^ this.getCompressionFormat() == null) {
            return false;
        }
        if (other.getCompressionFormat() != null && !other.getCompressionFormat().equals(this.getCompressionFormat())) {
            return false;
        }
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null) {
            return false;
        }
        if (other.getEncryptionConfiguration() != null && !other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration())) {
            return false;
        }
        if (other.getCloudWatchLoggingOptions() == null ^ this.getCloudWatchLoggingOptions() == null) {
            return false;
        }
        return other.getCloudWatchLoggingOptions() == null || other.getCloudWatchLoggingOptions().equals(this.getCloudWatchLoggingOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleARN() == null ? 0 : this.getRoleARN().hashCode());
        hashCode = 31 * hashCode + (this.getBucketARN() == null ? 0 : this.getBucketARN().hashCode());
        hashCode = 31 * hashCode + (this.getPrefix() == null ? 0 : this.getPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getBufferingHints() == null ? 0 : this.getBufferingHints().hashCode());
        hashCode = 31 * hashCode + (this.getCompressionFormat() == null ? 0 : this.getCompressionFormat().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfiguration() == null ? 0 : this.getEncryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchLoggingOptions() == null ? 0 : this.getCloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    public S3DestinationConfiguration clone() {
        try {
            return (S3DestinationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

