/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisfirehose.model.ProcessorParameter;
import com.amazonaws.services.kinesisfirehose.model.ProcessorType;
import com.amazonaws.services.kinesisfirehose.model.transform.ProcessorMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Processor
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private List<ProcessorParameter> parameters;

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public Processor withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(ProcessorType type) {
        this.withType(type);
    }

    public Processor withType(ProcessorType type) {
        this.type = type.toString();
        return this;
    }

    public List<ProcessorParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ProcessorParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<ProcessorParameter>(parameters);
    }

    public Processor withParameters(ProcessorParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<ProcessorParameter>(parameters.length));
        }
        for (ProcessorParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public Processor withParameters(Collection<ProcessorParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public Processor clone() {
        try {
            return (Processor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

