/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector.model.AssessmentRunNotification;
import com.amazonaws.services.inspector.model.AssessmentRunState;
import com.amazonaws.services.inspector.model.AssessmentRunStateChange;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AssessmentRunMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssessmentRun
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String name;
    private String assessmentTemplateArn;
    private String state;
    private Integer durationInSeconds;
    private List<String> rulesPackageArns;
    private List<Attribute> userAttributesForFindings;
    private Date createdAt;
    private Date startedAt;
    private Date completedAt;
    private Date stateChangedAt;
    private Boolean dataCollected;
    private List<AssessmentRunStateChange> stateChanges;
    private List<AssessmentRunNotification> notifications;
    private Map<String, Integer> findingCounts;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public AssessmentRun withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AssessmentRun withName(String name) {
        this.setName(name);
        return this;
    }

    public void setAssessmentTemplateArn(String assessmentTemplateArn) {
        this.assessmentTemplateArn = assessmentTemplateArn;
    }

    public String getAssessmentTemplateArn() {
        return this.assessmentTemplateArn;
    }

    public AssessmentRun withAssessmentTemplateArn(String assessmentTemplateArn) {
        this.setAssessmentTemplateArn(assessmentTemplateArn);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public AssessmentRun withState(String state) {
        this.setState(state);
        return this;
    }

    @JsonIgnore
    public void setState(AssessmentRunState state) {
        this.withState(state);
    }

    public AssessmentRun withState(AssessmentRunState state) {
        this.state = state.toString();
        return this;
    }

    public void setDurationInSeconds(Integer durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
    }

    public Integer getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public AssessmentRun withDurationInSeconds(Integer durationInSeconds) {
        this.setDurationInSeconds(durationInSeconds);
        return this;
    }

    public List<String> getRulesPackageArns() {
        return this.rulesPackageArns;
    }

    public void setRulesPackageArns(Collection<String> rulesPackageArns) {
        if (rulesPackageArns == null) {
            this.rulesPackageArns = null;
            return;
        }
        this.rulesPackageArns = new ArrayList<String>(rulesPackageArns);
    }

    public AssessmentRun withRulesPackageArns(String ... rulesPackageArns) {
        if (this.rulesPackageArns == null) {
            this.setRulesPackageArns(new ArrayList<String>(rulesPackageArns.length));
        }
        for (String ele : rulesPackageArns) {
            this.rulesPackageArns.add(ele);
        }
        return this;
    }

    public AssessmentRun withRulesPackageArns(Collection<String> rulesPackageArns) {
        this.setRulesPackageArns(rulesPackageArns);
        return this;
    }

    public List<Attribute> getUserAttributesForFindings() {
        return this.userAttributesForFindings;
    }

    public void setUserAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
        if (userAttributesForFindings == null) {
            this.userAttributesForFindings = null;
            return;
        }
        this.userAttributesForFindings = new ArrayList<Attribute>(userAttributesForFindings);
    }

    public AssessmentRun withUserAttributesForFindings(Attribute ... userAttributesForFindings) {
        if (this.userAttributesForFindings == null) {
            this.setUserAttributesForFindings(new ArrayList<Attribute>(userAttributesForFindings.length));
        }
        for (Attribute ele : userAttributesForFindings) {
            this.userAttributesForFindings.add(ele);
        }
        return this;
    }

    public AssessmentRun withUserAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
        this.setUserAttributesForFindings(userAttributesForFindings);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public AssessmentRun withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public AssessmentRun withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setCompletedAt(Date completedAt) {
        this.completedAt = completedAt;
    }

    public Date getCompletedAt() {
        return this.completedAt;
    }

    public AssessmentRun withCompletedAt(Date completedAt) {
        this.setCompletedAt(completedAt);
        return this;
    }

    public void setStateChangedAt(Date stateChangedAt) {
        this.stateChangedAt = stateChangedAt;
    }

    public Date getStateChangedAt() {
        return this.stateChangedAt;
    }

    public AssessmentRun withStateChangedAt(Date stateChangedAt) {
        this.setStateChangedAt(stateChangedAt);
        return this;
    }

    public void setDataCollected(Boolean dataCollected) {
        this.dataCollected = dataCollected;
    }

    public Boolean getDataCollected() {
        return this.dataCollected;
    }

    public AssessmentRun withDataCollected(Boolean dataCollected) {
        this.setDataCollected(dataCollected);
        return this;
    }

    public Boolean isDataCollected() {
        return this.dataCollected;
    }

    public List<AssessmentRunStateChange> getStateChanges() {
        return this.stateChanges;
    }

    public void setStateChanges(Collection<AssessmentRunStateChange> stateChanges) {
        if (stateChanges == null) {
            this.stateChanges = null;
            return;
        }
        this.stateChanges = new ArrayList<AssessmentRunStateChange>(stateChanges);
    }

    public AssessmentRun withStateChanges(AssessmentRunStateChange ... stateChanges) {
        if (this.stateChanges == null) {
            this.setStateChanges(new ArrayList<AssessmentRunStateChange>(stateChanges.length));
        }
        for (AssessmentRunStateChange ele : stateChanges) {
            this.stateChanges.add(ele);
        }
        return this;
    }

    public AssessmentRun withStateChanges(Collection<AssessmentRunStateChange> stateChanges) {
        this.setStateChanges(stateChanges);
        return this;
    }

    public List<AssessmentRunNotification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Collection<AssessmentRunNotification> notifications) {
        if (notifications == null) {
            this.notifications = null;
            return;
        }
        this.notifications = new ArrayList<AssessmentRunNotification>(notifications);
    }

    public AssessmentRun withNotifications(AssessmentRunNotification ... notifications) {
        if (this.notifications == null) {
            this.setNotifications(new ArrayList<AssessmentRunNotification>(notifications.length));
        }
        for (AssessmentRunNotification ele : notifications) {
            this.notifications.add(ele);
        }
        return this;
    }

    public AssessmentRun withNotifications(Collection<AssessmentRunNotification> notifications) {
        this.setNotifications(notifications);
        return this;
    }

    public Map<String, Integer> getFindingCounts() {
        return this.findingCounts;
    }

    public void setFindingCounts(Map<String, Integer> findingCounts) {
        this.findingCounts = findingCounts;
    }

    public AssessmentRun withFindingCounts(Map<String, Integer> findingCounts) {
        this.setFindingCounts(findingCounts);
        return this;
    }

    public AssessmentRun addFindingCountsEntry(String key, Integer value) {
        if (null == this.findingCounts) {
            this.findingCounts = new HashMap<String, Integer>();
        }
        if (this.findingCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.findingCounts.put(key, value);
        return this;
    }

    public AssessmentRun clearFindingCountsEntries() {
        this.findingCounts = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAssessmentTemplateArn() != null) {
            sb.append("AssessmentTemplateArn: ").append(this.getAssessmentTemplateArn()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getDurationInSeconds() != null) {
            sb.append("DurationInSeconds: ").append(this.getDurationInSeconds()).append(",");
        }
        if (this.getRulesPackageArns() != null) {
            sb.append("RulesPackageArns: ").append(this.getRulesPackageArns()).append(",");
        }
        if (this.getUserAttributesForFindings() != null) {
            sb.append("UserAttributesForFindings: ").append(this.getUserAttributesForFindings()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getCompletedAt() != null) {
            sb.append("CompletedAt: ").append(this.getCompletedAt()).append(",");
        }
        if (this.getStateChangedAt() != null) {
            sb.append("StateChangedAt: ").append(this.getStateChangedAt()).append(",");
        }
        if (this.getDataCollected() != null) {
            sb.append("DataCollected: ").append(this.getDataCollected()).append(",");
        }
        if (this.getStateChanges() != null) {
            sb.append("StateChanges: ").append(this.getStateChanges()).append(",");
        }
        if (this.getNotifications() != null) {
            sb.append("Notifications: ").append(this.getNotifications()).append(",");
        }
        if (this.getFindingCounts() != null) {
            sb.append("FindingCounts: ").append(this.getFindingCounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRun)) {
            return false;
        }
        AssessmentRun other = (AssessmentRun)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAssessmentTemplateArn() == null ^ this.getAssessmentTemplateArn() == null) {
            return false;
        }
        if (other.getAssessmentTemplateArn() != null && !other.getAssessmentTemplateArn().equals(this.getAssessmentTemplateArn())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getDurationInSeconds() == null ^ this.getDurationInSeconds() == null) {
            return false;
        }
        if (other.getDurationInSeconds() != null && !other.getDurationInSeconds().equals(this.getDurationInSeconds())) {
            return false;
        }
        if (other.getRulesPackageArns() == null ^ this.getRulesPackageArns() == null) {
            return false;
        }
        if (other.getRulesPackageArns() != null && !other.getRulesPackageArns().equals(this.getRulesPackageArns())) {
            return false;
        }
        if (other.getUserAttributesForFindings() == null ^ this.getUserAttributesForFindings() == null) {
            return false;
        }
        if (other.getUserAttributesForFindings() != null && !other.getUserAttributesForFindings().equals(this.getUserAttributesForFindings())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getCompletedAt() == null ^ this.getCompletedAt() == null) {
            return false;
        }
        if (other.getCompletedAt() != null && !other.getCompletedAt().equals(this.getCompletedAt())) {
            return false;
        }
        if (other.getStateChangedAt() == null ^ this.getStateChangedAt() == null) {
            return false;
        }
        if (other.getStateChangedAt() != null && !other.getStateChangedAt().equals(this.getStateChangedAt())) {
            return false;
        }
        if (other.getDataCollected() == null ^ this.getDataCollected() == null) {
            return false;
        }
        if (other.getDataCollected() != null && !other.getDataCollected().equals(this.getDataCollected())) {
            return false;
        }
        if (other.getStateChanges() == null ^ this.getStateChanges() == null) {
            return false;
        }
        if (other.getStateChanges() != null && !other.getStateChanges().equals(this.getStateChanges())) {
            return false;
        }
        if (other.getNotifications() == null ^ this.getNotifications() == null) {
            return false;
        }
        if (other.getNotifications() != null && !other.getNotifications().equals(this.getNotifications())) {
            return false;
        }
        if (other.getFindingCounts() == null ^ this.getFindingCounts() == null) {
            return false;
        }
        return other.getFindingCounts() == null || other.getFindingCounts().equals(this.getFindingCounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAssessmentTemplateArn() == null ? 0 : this.getAssessmentTemplateArn().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getDurationInSeconds() == null ? 0 : this.getDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getRulesPackageArns() == null ? 0 : this.getRulesPackageArns().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributesForFindings() == null ? 0 : this.getUserAttributesForFindings().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getCompletedAt() == null ? 0 : this.getCompletedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStateChangedAt() == null ? 0 : this.getStateChangedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDataCollected() == null ? 0 : this.getDataCollected().hashCode());
        hashCode = 31 * hashCode + (this.getStateChanges() == null ? 0 : this.getStateChanges().hashCode());
        hashCode = 31 * hashCode + (this.getNotifications() == null ? 0 : this.getNotifications().hashCode());
        hashCode = 31 * hashCode + (this.getFindingCounts() == null ? 0 : this.getFindingCounts().hashCode());
        return hashCode;
    }

    public AssessmentRun clone() {
        try {
            return (AssessmentRun)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssessmentRunMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

