/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.identitymanagement.model.OrganizationsDecisionDetail;
import com.amazonaws.services.identitymanagement.model.PolicyEvaluationDecisionType;
import com.amazonaws.services.identitymanagement.model.ResourceSpecificResult;
import com.amazonaws.services.identitymanagement.model.Statement;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EvaluationResult
implements Serializable,
Cloneable {
    private String evalActionName;
    private String evalResourceName;
    private String evalDecision;
    private SdkInternalList<Statement> matchedStatements;
    private SdkInternalList<String> missingContextValues;
    private OrganizationsDecisionDetail organizationsDecisionDetail;
    private SdkInternalMap<String, String> evalDecisionDetails;
    private SdkInternalList<ResourceSpecificResult> resourceSpecificResults;

    public void setEvalActionName(String evalActionName) {
        this.evalActionName = evalActionName;
    }

    public String getEvalActionName() {
        return this.evalActionName;
    }

    public EvaluationResult withEvalActionName(String evalActionName) {
        this.setEvalActionName(evalActionName);
        return this;
    }

    public void setEvalResourceName(String evalResourceName) {
        this.evalResourceName = evalResourceName;
    }

    public String getEvalResourceName() {
        return this.evalResourceName;
    }

    public EvaluationResult withEvalResourceName(String evalResourceName) {
        this.setEvalResourceName(evalResourceName);
        return this;
    }

    public void setEvalDecision(String evalDecision) {
        this.evalDecision = evalDecision;
    }

    @JsonProperty(value="evalDecision")
    public String getEvalDecision() {
        return this.evalDecision;
    }

    public EvaluationResult withEvalDecision(String evalDecision) {
        this.setEvalDecision(evalDecision);
        return this;
    }

    @JsonIgnore
    public void setEvalDecision(PolicyEvaluationDecisionType evalDecision) {
        this.withEvalDecision(evalDecision);
    }

    public EvaluationResult withEvalDecision(PolicyEvaluationDecisionType evalDecision) {
        this.evalDecision = evalDecision.toString();
        return this;
    }

    public List<Statement> getMatchedStatements() {
        if (this.matchedStatements == null) {
            this.matchedStatements = new SdkInternalList();
        }
        return this.matchedStatements;
    }

    public void setMatchedStatements(Collection<Statement> matchedStatements) {
        if (matchedStatements == null) {
            this.matchedStatements = null;
            return;
        }
        this.matchedStatements = new SdkInternalList<Statement>(matchedStatements);
    }

    public EvaluationResult withMatchedStatements(Statement ... matchedStatements) {
        if (this.matchedStatements == null) {
            this.setMatchedStatements(new SdkInternalList<Statement>(matchedStatements.length));
        }
        for (Statement ele : matchedStatements) {
            this.matchedStatements.add(ele);
        }
        return this;
    }

    public EvaluationResult withMatchedStatements(Collection<Statement> matchedStatements) {
        this.setMatchedStatements(matchedStatements);
        return this;
    }

    public List<String> getMissingContextValues() {
        if (this.missingContextValues == null) {
            this.missingContextValues = new SdkInternalList();
        }
        return this.missingContextValues;
    }

    public void setMissingContextValues(Collection<String> missingContextValues) {
        if (missingContextValues == null) {
            this.missingContextValues = null;
            return;
        }
        this.missingContextValues = new SdkInternalList<String>(missingContextValues);
    }

    public EvaluationResult withMissingContextValues(String ... missingContextValues) {
        if (this.missingContextValues == null) {
            this.setMissingContextValues(new SdkInternalList<String>(missingContextValues.length));
        }
        for (String ele : missingContextValues) {
            this.missingContextValues.add(ele);
        }
        return this;
    }

    public EvaluationResult withMissingContextValues(Collection<String> missingContextValues) {
        this.setMissingContextValues(missingContextValues);
        return this;
    }

    public void setOrganizationsDecisionDetail(OrganizationsDecisionDetail organizationsDecisionDetail) {
        this.organizationsDecisionDetail = organizationsDecisionDetail;
    }

    public OrganizationsDecisionDetail getOrganizationsDecisionDetail() {
        return this.organizationsDecisionDetail;
    }

    public EvaluationResult withOrganizationsDecisionDetail(OrganizationsDecisionDetail organizationsDecisionDetail) {
        this.setOrganizationsDecisionDetail(organizationsDecisionDetail);
        return this;
    }

    public Map<String, String> getEvalDecisionDetails() {
        if (this.evalDecisionDetails == null) {
            this.evalDecisionDetails = new SdkInternalMap();
        }
        return this.evalDecisionDetails;
    }

    public void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.evalDecisionDetails = evalDecisionDetails == null ? null : new SdkInternalMap<String, String>(evalDecisionDetails);
    }

    public EvaluationResult withEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.setEvalDecisionDetails(evalDecisionDetails);
        return this;
    }

    public EvaluationResult addEvalDecisionDetailsEntry(String key, String value) {
        if (null == this.evalDecisionDetails) {
            this.evalDecisionDetails = new SdkInternalMap();
        }
        if (this.evalDecisionDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.evalDecisionDetails.put(key, value);
        return this;
    }

    public EvaluationResult clearEvalDecisionDetailsEntries() {
        this.evalDecisionDetails = null;
        return this;
    }

    public List<ResourceSpecificResult> getResourceSpecificResults() {
        if (this.resourceSpecificResults == null) {
            this.resourceSpecificResults = new SdkInternalList();
        }
        return this.resourceSpecificResults;
    }

    public void setResourceSpecificResults(Collection<ResourceSpecificResult> resourceSpecificResults) {
        if (resourceSpecificResults == null) {
            this.resourceSpecificResults = null;
            return;
        }
        this.resourceSpecificResults = new SdkInternalList<ResourceSpecificResult>(resourceSpecificResults);
    }

    public EvaluationResult withResourceSpecificResults(ResourceSpecificResult ... resourceSpecificResults) {
        if (this.resourceSpecificResults == null) {
            this.setResourceSpecificResults(new SdkInternalList<ResourceSpecificResult>(resourceSpecificResults.length));
        }
        for (ResourceSpecificResult ele : resourceSpecificResults) {
            this.resourceSpecificResults.add(ele);
        }
        return this;
    }

    public EvaluationResult withResourceSpecificResults(Collection<ResourceSpecificResult> resourceSpecificResults) {
        this.setResourceSpecificResults(resourceSpecificResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvalActionName() != null) {
            sb.append("EvalActionName: ").append(this.getEvalActionName()).append(",");
        }
        if (this.getEvalResourceName() != null) {
            sb.append("EvalResourceName: ").append(this.getEvalResourceName()).append(",");
        }
        if (this.getEvalDecision() != null) {
            sb.append("EvalDecision: ").append(this.getEvalDecision()).append(",");
        }
        if (this.getMatchedStatements() != null) {
            sb.append("MatchedStatements: ").append(this.getMatchedStatements()).append(",");
        }
        if (this.getMissingContextValues() != null) {
            sb.append("MissingContextValues: ").append(this.getMissingContextValues()).append(",");
        }
        if (this.getOrganizationsDecisionDetail() != null) {
            sb.append("OrganizationsDecisionDetail: ").append(this.getOrganizationsDecisionDetail()).append(",");
        }
        if (this.getEvalDecisionDetails() != null) {
            sb.append("EvalDecisionDetails: ").append(this.getEvalDecisionDetails()).append(",");
        }
        if (this.getResourceSpecificResults() != null) {
            sb.append("ResourceSpecificResults: ").append(this.getResourceSpecificResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        if (other.getEvalActionName() == null ^ this.getEvalActionName() == null) {
            return false;
        }
        if (other.getEvalActionName() != null && !other.getEvalActionName().equals(this.getEvalActionName())) {
            return false;
        }
        if (other.getEvalResourceName() == null ^ this.getEvalResourceName() == null) {
            return false;
        }
        if (other.getEvalResourceName() != null && !other.getEvalResourceName().equals(this.getEvalResourceName())) {
            return false;
        }
        if (other.getEvalDecision() == null ^ this.getEvalDecision() == null) {
            return false;
        }
        if (other.getEvalDecision() != null && !other.getEvalDecision().equals(this.getEvalDecision())) {
            return false;
        }
        if (other.getMatchedStatements() == null ^ this.getMatchedStatements() == null) {
            return false;
        }
        if (other.getMatchedStatements() != null && !other.getMatchedStatements().equals(this.getMatchedStatements())) {
            return false;
        }
        if (other.getMissingContextValues() == null ^ this.getMissingContextValues() == null) {
            return false;
        }
        if (other.getMissingContextValues() != null && !other.getMissingContextValues().equals(this.getMissingContextValues())) {
            return false;
        }
        if (other.getOrganizationsDecisionDetail() == null ^ this.getOrganizationsDecisionDetail() == null) {
            return false;
        }
        if (other.getOrganizationsDecisionDetail() != null && !other.getOrganizationsDecisionDetail().equals(this.getOrganizationsDecisionDetail())) {
            return false;
        }
        if (other.getEvalDecisionDetails() == null ^ this.getEvalDecisionDetails() == null) {
            return false;
        }
        if (other.getEvalDecisionDetails() != null && !other.getEvalDecisionDetails().equals(this.getEvalDecisionDetails())) {
            return false;
        }
        if (other.getResourceSpecificResults() == null ^ this.getResourceSpecificResults() == null) {
            return false;
        }
        return other.getResourceSpecificResults() == null || other.getResourceSpecificResults().equals(this.getResourceSpecificResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvalActionName() == null ? 0 : this.getEvalActionName().hashCode());
        hashCode = 31 * hashCode + (this.getEvalResourceName() == null ? 0 : this.getEvalResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getEvalDecision() == null ? 0 : this.getEvalDecision().hashCode());
        hashCode = 31 * hashCode + (this.getMatchedStatements() == null ? 0 : this.getMatchedStatements().hashCode());
        hashCode = 31 * hashCode + (this.getMissingContextValues() == null ? 0 : this.getMissingContextValues().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationsDecisionDetail() == null ? 0 : this.getOrganizationsDecisionDetail().hashCode());
        hashCode = 31 * hashCode + (this.getEvalDecisionDetails() == null ? 0 : this.getEvalDecisionDetails().hashCode());
        hashCode = 31 * hashCode + (this.getResourceSpecificResults() == null ? 0 : this.getResourceSpecificResults().hashCode());
        return hashCode;
    }

    public EvaluationResult clone() {
        try {
            return (EvaluationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

