/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreatePlayerSessionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String gameSessionId;
    private List<String> playerIds;
    private Map<String, String> playerDataMap;

    public void setGameSessionId(String gameSessionId) {
        this.gameSessionId = gameSessionId;
    }

    public String getGameSessionId() {
        return this.gameSessionId;
    }

    public CreatePlayerSessionsRequest withGameSessionId(String gameSessionId) {
        this.setGameSessionId(gameSessionId);
        return this;
    }

    public List<String> getPlayerIds() {
        return this.playerIds;
    }

    public void setPlayerIds(Collection<String> playerIds) {
        if (playerIds == null) {
            this.playerIds = null;
            return;
        }
        this.playerIds = new ArrayList<String>(playerIds);
    }

    public CreatePlayerSessionsRequest withPlayerIds(String ... playerIds) {
        if (this.playerIds == null) {
            this.setPlayerIds(new ArrayList<String>(playerIds.length));
        }
        for (String ele : playerIds) {
            this.playerIds.add(ele);
        }
        return this;
    }

    public CreatePlayerSessionsRequest withPlayerIds(Collection<String> playerIds) {
        this.setPlayerIds(playerIds);
        return this;
    }

    public Map<String, String> getPlayerDataMap() {
        return this.playerDataMap;
    }

    public void setPlayerDataMap(Map<String, String> playerDataMap) {
        this.playerDataMap = playerDataMap;
    }

    public CreatePlayerSessionsRequest withPlayerDataMap(Map<String, String> playerDataMap) {
        this.setPlayerDataMap(playerDataMap);
        return this;
    }

    public CreatePlayerSessionsRequest addPlayerDataMapEntry(String key, String value) {
        if (null == this.playerDataMap) {
            this.playerDataMap = new HashMap<String, String>();
        }
        if (this.playerDataMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.playerDataMap.put(key, value);
        return this;
    }

    public CreatePlayerSessionsRequest clearPlayerDataMapEntries() {
        this.playerDataMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.getGameSessionId()).append(",");
        }
        if (this.getPlayerIds() != null) {
            sb.append("PlayerIds: ").append(this.getPlayerIds()).append(",");
        }
        if (this.getPlayerDataMap() != null) {
            sb.append("PlayerDataMap: ").append(this.getPlayerDataMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionsRequest)) {
            return false;
        }
        CreatePlayerSessionsRequest other = (CreatePlayerSessionsRequest)obj;
        if (other.getGameSessionId() == null ^ this.getGameSessionId() == null) {
            return false;
        }
        if (other.getGameSessionId() != null && !other.getGameSessionId().equals(this.getGameSessionId())) {
            return false;
        }
        if (other.getPlayerIds() == null ^ this.getPlayerIds() == null) {
            return false;
        }
        if (other.getPlayerIds() != null && !other.getPlayerIds().equals(this.getPlayerIds())) {
            return false;
        }
        if (other.getPlayerDataMap() == null ^ this.getPlayerDataMap() == null) {
            return false;
        }
        return other.getPlayerDataMap() == null || other.getPlayerDataMap().equals(this.getPlayerDataMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGameSessionId() == null ? 0 : this.getGameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerIds() == null ? 0 : this.getPlayerIds().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerDataMap() == null ? 0 : this.getPlayerDataMap().hashCode());
        return hashCode;
    }

    @Override
    public CreatePlayerSessionsRequest clone() {
        return (CreatePlayerSessionsRequest)super.clone();
    }
}

