/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dax.model.SubnetGroup;
import java.util.List;

@SdkInternalApi
public class SubnetGroupMarshaller {
    private static final MarshallingInfo<String> SUBNETGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetGroupName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subnets").build();
    private static final SubnetGroupMarshaller instance = new SubnetGroupMarshaller();

    public static SubnetGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(SubnetGroup subnetGroup, ProtocolMarshaller protocolMarshaller) {
        if (subnetGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(subnetGroup.getSubnetGroupName(), SUBNETGROUPNAME_BINDING);
            protocolMarshaller.marshall(subnetGroup.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(subnetGroup.getVpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(subnetGroup.getSubnets(), SUBNETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

