/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentHashType;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentParameter;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentStatus;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentType;
import com.amazonaws.services.simplesystemsmanagement.model.PlatformType;
import com.amazonaws.services.simplesystemsmanagement.model.transform.DocumentDescriptionMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DocumentDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String sha1;
    private String hash;
    private String hashType;
    private String name;
    private String owner;
    private Date createdDate;
    private String status;
    private String documentVersion;
    private String description;
    private SdkInternalList<DocumentParameter> parameters;
    private SdkInternalList<String> platformTypes;
    private String documentType;
    private String schemaVersion;
    private String latestVersion;
    private String defaultVersion;

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getSha1() {
        return this.sha1;
    }

    public DocumentDescription withSha1(String sha1) {
        this.setSha1(sha1);
        return this;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getHash() {
        return this.hash;
    }

    public DocumentDescription withHash(String hash) {
        this.setHash(hash);
        return this;
    }

    public void setHashType(String hashType) {
        this.hashType = hashType;
    }

    @JsonProperty(value="hashType")
    public String getHashType() {
        return this.hashType;
    }

    public DocumentDescription withHashType(String hashType) {
        this.setHashType(hashType);
        return this;
    }

    @JsonIgnore
    public void setHashType(DocumentHashType hashType) {
        this.withHashType(hashType);
    }

    public DocumentDescription withHashType(DocumentHashType hashType) {
        this.hashType = hashType.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DocumentDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public DocumentDescription withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public DocumentDescription withCreatedDate(Date createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public DocumentDescription withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(DocumentStatus status) {
        this.withStatus(status);
    }

    public DocumentDescription withStatus(DocumentStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public DocumentDescription withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentDescription withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<DocumentParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new SdkInternalList();
        }
        return this.parameters;
    }

    public void setParameters(Collection<DocumentParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new SdkInternalList<DocumentParameter>(parameters);
    }

    public DocumentDescription withParameters(DocumentParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new SdkInternalList<DocumentParameter>(parameters.length));
        }
        for (DocumentParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public DocumentDescription withParameters(Collection<DocumentParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public List<String> getPlatformTypes() {
        if (this.platformTypes == null) {
            this.platformTypes = new SdkInternalList();
        }
        return this.platformTypes;
    }

    public void setPlatformTypes(Collection<String> platformTypes) {
        if (platformTypes == null) {
            this.platformTypes = null;
            return;
        }
        this.platformTypes = new SdkInternalList<String>(platformTypes);
    }

    public DocumentDescription withPlatformTypes(String ... platformTypes) {
        if (this.platformTypes == null) {
            this.setPlatformTypes(new SdkInternalList<String>(platformTypes.length));
        }
        for (String ele : platformTypes) {
            this.platformTypes.add(ele);
        }
        return this;
    }

    public DocumentDescription withPlatformTypes(Collection<String> platformTypes) {
        this.setPlatformTypes(platformTypes);
        return this;
    }

    public DocumentDescription withPlatformTypes(PlatformType ... platformTypes) {
        SdkInternalList<String> platformTypesCopy = new SdkInternalList<String>(platformTypes.length);
        for (PlatformType value : platformTypes) {
            platformTypesCopy.add(value.toString());
        }
        if (this.getPlatformTypes() == null) {
            this.setPlatformTypes(platformTypesCopy);
        } else {
            this.getPlatformTypes().addAll(platformTypesCopy);
        }
        return this;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    @JsonProperty(value="documentType")
    public String getDocumentType() {
        return this.documentType;
    }

    public DocumentDescription withDocumentType(String documentType) {
        this.setDocumentType(documentType);
        return this;
    }

    @JsonIgnore
    public void setDocumentType(DocumentType documentType) {
        this.withDocumentType(documentType);
    }

    public DocumentDescription withDocumentType(DocumentType documentType) {
        this.documentType = documentType.toString();
        return this;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public DocumentDescription withSchemaVersion(String schemaVersion) {
        this.setSchemaVersion(schemaVersion);
        return this;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public DocumentDescription withLatestVersion(String latestVersion) {
        this.setLatestVersion(latestVersion);
        return this;
    }

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    public DocumentDescription withDefaultVersion(String defaultVersion) {
        this.setDefaultVersion(defaultVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSha1() != null) {
            sb.append("Sha1: ").append(this.getSha1()).append(",");
        }
        if (this.getHash() != null) {
            sb.append("Hash: ").append(this.getHash()).append(",");
        }
        if (this.getHashType() != null) {
            sb.append("HashType: ").append(this.getHashType()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getPlatformTypes() != null) {
            sb.append("PlatformTypes: ").append(this.getPlatformTypes()).append(",");
        }
        if (this.getDocumentType() != null) {
            sb.append("DocumentType: ").append(this.getDocumentType()).append(",");
        }
        if (this.getSchemaVersion() != null) {
            sb.append("SchemaVersion: ").append(this.getSchemaVersion()).append(",");
        }
        if (this.getLatestVersion() != null) {
            sb.append("LatestVersion: ").append(this.getLatestVersion()).append(",");
        }
        if (this.getDefaultVersion() != null) {
            sb.append("DefaultVersion: ").append(this.getDefaultVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription)obj;
        if (other.getSha1() == null ^ this.getSha1() == null) {
            return false;
        }
        if (other.getSha1() != null && !other.getSha1().equals(this.getSha1())) {
            return false;
        }
        if (other.getHash() == null ^ this.getHash() == null) {
            return false;
        }
        if (other.getHash() != null && !other.getHash().equals(this.getHash())) {
            return false;
        }
        if (other.getHashType() == null ^ this.getHashType() == null) {
            return false;
        }
        if (other.getHashType() != null && !other.getHashType().equals(this.getHashType())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getPlatformTypes() == null ^ this.getPlatformTypes() == null) {
            return false;
        }
        if (other.getPlatformTypes() != null && !other.getPlatformTypes().equals(this.getPlatformTypes())) {
            return false;
        }
        if (other.getDocumentType() == null ^ this.getDocumentType() == null) {
            return false;
        }
        if (other.getDocumentType() != null && !other.getDocumentType().equals(this.getDocumentType())) {
            return false;
        }
        if (other.getSchemaVersion() == null ^ this.getSchemaVersion() == null) {
            return false;
        }
        if (other.getSchemaVersion() != null && !other.getSchemaVersion().equals(this.getSchemaVersion())) {
            return false;
        }
        if (other.getLatestVersion() == null ^ this.getLatestVersion() == null) {
            return false;
        }
        if (other.getLatestVersion() != null && !other.getLatestVersion().equals(this.getLatestVersion())) {
            return false;
        }
        if (other.getDefaultVersion() == null ^ this.getDefaultVersion() == null) {
            return false;
        }
        return other.getDefaultVersion() == null || other.getDefaultVersion().equals(this.getDefaultVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSha1() == null ? 0 : this.getSha1().hashCode());
        hashCode = 31 * hashCode + (this.getHash() == null ? 0 : this.getHash().hashCode());
        hashCode = 31 * hashCode + (this.getHashType() == null ? 0 : this.getHashType().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformTypes() == null ? 0 : this.getPlatformTypes().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentType() == null ? 0 : this.getDocumentType().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaVersion() == null ? 0 : this.getSchemaVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLatestVersion() == null ? 0 : this.getLatestVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultVersion() == null ? 0 : this.getDefaultVersion().hashCode());
        return hashCode;
    }

    public DocumentDescription clone() {
        try {
            return (DocumentDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

