/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CurrencyCodeValues;
import com.amazonaws.services.ec2.model.PaymentOption;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Purchase
implements Serializable,
Cloneable {
    private String currencyCode;
    private Integer duration;
    private SdkInternalList<String> hostIdSet;
    private String hostReservationId;
    private String hourlyPrice;
    private String instanceFamily;
    private String paymentOption;
    private String upfrontPrice;

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonProperty(value="currencyCode")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Purchase withCurrencyCode(String currencyCode) {
        this.setCurrencyCode(currencyCode);
        return this;
    }

    @JsonIgnore
    public void setCurrencyCode(CurrencyCodeValues currencyCode) {
        this.withCurrencyCode(currencyCode);
    }

    public Purchase withCurrencyCode(CurrencyCodeValues currencyCode) {
        this.currencyCode = currencyCode.toString();
        return this;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Purchase withDuration(Integer duration) {
        this.setDuration(duration);
        return this;
    }

    public List<String> getHostIdSet() {
        if (this.hostIdSet == null) {
            this.hostIdSet = new SdkInternalList();
        }
        return this.hostIdSet;
    }

    public void setHostIdSet(Collection<String> hostIdSet) {
        if (hostIdSet == null) {
            this.hostIdSet = null;
            return;
        }
        this.hostIdSet = new SdkInternalList<String>(hostIdSet);
    }

    public Purchase withHostIdSet(String ... hostIdSet) {
        if (this.hostIdSet == null) {
            this.setHostIdSet(new SdkInternalList<String>(hostIdSet.length));
        }
        for (String ele : hostIdSet) {
            this.hostIdSet.add(ele);
        }
        return this;
    }

    public Purchase withHostIdSet(Collection<String> hostIdSet) {
        this.setHostIdSet(hostIdSet);
        return this;
    }

    public void setHostReservationId(String hostReservationId) {
        this.hostReservationId = hostReservationId;
    }

    public String getHostReservationId() {
        return this.hostReservationId;
    }

    public Purchase withHostReservationId(String hostReservationId) {
        this.setHostReservationId(hostReservationId);
        return this;
    }

    public void setHourlyPrice(String hourlyPrice) {
        this.hourlyPrice = hourlyPrice;
    }

    public String getHourlyPrice() {
        return this.hourlyPrice;
    }

    public Purchase withHourlyPrice(String hourlyPrice) {
        this.setHourlyPrice(hourlyPrice);
        return this;
    }

    public void setInstanceFamily(String instanceFamily) {
        this.instanceFamily = instanceFamily;
    }

    public String getInstanceFamily() {
        return this.instanceFamily;
    }

    public Purchase withInstanceFamily(String instanceFamily) {
        this.setInstanceFamily(instanceFamily);
        return this;
    }

    public void setPaymentOption(String paymentOption) {
        this.paymentOption = paymentOption;
    }

    @JsonProperty(value="paymentOption")
    public String getPaymentOption() {
        return this.paymentOption;
    }

    public Purchase withPaymentOption(String paymentOption) {
        this.setPaymentOption(paymentOption);
        return this;
    }

    @JsonIgnore
    public void setPaymentOption(PaymentOption paymentOption) {
        this.withPaymentOption(paymentOption);
    }

    public Purchase withPaymentOption(PaymentOption paymentOption) {
        this.paymentOption = paymentOption.toString();
        return this;
    }

    public void setUpfrontPrice(String upfrontPrice) {
        this.upfrontPrice = upfrontPrice;
    }

    public String getUpfrontPrice() {
        return this.upfrontPrice;
    }

    public Purchase withUpfrontPrice(String upfrontPrice) {
        this.setUpfrontPrice(upfrontPrice);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCurrencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.getCurrencyCode()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getHostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.getHostIdSet()).append(",");
        }
        if (this.getHostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.getHostReservationId()).append(",");
        }
        if (this.getHourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(this.getHourlyPrice()).append(",");
        }
        if (this.getInstanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.getInstanceFamily()).append(",");
        }
        if (this.getPaymentOption() != null) {
            sb.append("PaymentOption: ").append(this.getPaymentOption()).append(",");
        }
        if (this.getUpfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(this.getUpfrontPrice());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Purchase)) {
            return false;
        }
        Purchase other = (Purchase)obj;
        if (other.getCurrencyCode() == null ^ this.getCurrencyCode() == null) {
            return false;
        }
        if (other.getCurrencyCode() != null && !other.getCurrencyCode().equals(this.getCurrencyCode())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getHostIdSet() == null ^ this.getHostIdSet() == null) {
            return false;
        }
        if (other.getHostIdSet() != null && !other.getHostIdSet().equals(this.getHostIdSet())) {
            return false;
        }
        if (other.getHostReservationId() == null ^ this.getHostReservationId() == null) {
            return false;
        }
        if (other.getHostReservationId() != null && !other.getHostReservationId().equals(this.getHostReservationId())) {
            return false;
        }
        if (other.getHourlyPrice() == null ^ this.getHourlyPrice() == null) {
            return false;
        }
        if (other.getHourlyPrice() != null && !other.getHourlyPrice().equals(this.getHourlyPrice())) {
            return false;
        }
        if (other.getInstanceFamily() == null ^ this.getInstanceFamily() == null) {
            return false;
        }
        if (other.getInstanceFamily() != null && !other.getInstanceFamily().equals(this.getInstanceFamily())) {
            return false;
        }
        if (other.getPaymentOption() == null ^ this.getPaymentOption() == null) {
            return false;
        }
        if (other.getPaymentOption() != null && !other.getPaymentOption().equals(this.getPaymentOption())) {
            return false;
        }
        if (other.getUpfrontPrice() == null ^ this.getUpfrontPrice() == null) {
            return false;
        }
        return other.getUpfrontPrice() == null || other.getUpfrontPrice().equals(this.getUpfrontPrice());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCurrencyCode() == null ? 0 : this.getCurrencyCode().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getHostIdSet() == null ? 0 : this.getHostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.getHostReservationId() == null ? 0 : this.getHostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.getHourlyPrice() == null ? 0 : this.getHourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFamily() == null ? 0 : this.getInstanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentOption() == null ? 0 : this.getPaymentOption().hashCode());
        hashCode = 31 * hashCode + (this.getUpfrontPrice() == null ? 0 : this.getUpfrontPrice().hashCode());
        return hashCode;
    }

    public Purchase clone() {
        try {
            return (Purchase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

