/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.DevicePlatform;
import com.amazonaws.services.devicefarm.model.OfferingType;
import com.amazonaws.services.devicefarm.model.RecurringCharge;
import com.amazonaws.services.devicefarm.model.transform.OfferingMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Offering
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String description;
    private String type;
    private String platform;
    private List<RecurringCharge> recurringCharges;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Offering withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Offering withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public Offering withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(OfferingType type) {
        this.withType(type);
    }

    public Offering withType(OfferingType type) {
        this.type = type.toString();
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @JsonProperty(value="platform")
    public String getPlatform() {
        return this.platform;
    }

    public Offering withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    @JsonIgnore
    public void setPlatform(DevicePlatform platform) {
        this.withPlatform(platform);
    }

    public Offering withPlatform(DevicePlatform platform) {
        this.platform = platform.toString();
        return this;
    }

    public List<RecurringCharge> getRecurringCharges() {
        return this.recurringCharges;
    }

    public void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
        if (recurringCharges == null) {
            this.recurringCharges = null;
            return;
        }
        this.recurringCharges = new ArrayList<RecurringCharge>(recurringCharges);
    }

    public Offering withRecurringCharges(RecurringCharge ... recurringCharges) {
        if (this.recurringCharges == null) {
            this.setRecurringCharges(new ArrayList<RecurringCharge>(recurringCharges.length));
        }
        for (RecurringCharge ele : recurringCharges) {
            this.recurringCharges.add(ele);
        }
        return this;
    }

    public Offering withRecurringCharges(Collection<RecurringCharge> recurringCharges) {
        this.setRecurringCharges(recurringCharges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getRecurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.getRecurringCharges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offering)) {
            return false;
        }
        Offering other = (Offering)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getRecurringCharges() == null ^ this.getRecurringCharges() == null) {
            return false;
        }
        return other.getRecurringCharges() == null || other.getRecurringCharges().equals(this.getRecurringCharges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getRecurringCharges() == null ? 0 : this.getRecurringCharges().hashCode());
        return hashCode;
    }

    public Offering clone() {
        try {
            return (Offering)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

