/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ParameterValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ActivatePipelineRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineId;
    private SdkInternalList<ParameterValue> parameterValues;
    private Date startTimestamp;

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public ActivatePipelineRequest withPipelineId(String pipelineId) {
        this.setPipelineId(pipelineId);
        return this;
    }

    public List<ParameterValue> getParameterValues() {
        if (this.parameterValues == null) {
            this.parameterValues = new SdkInternalList();
        }
        return this.parameterValues;
    }

    public void setParameterValues(Collection<ParameterValue> parameterValues) {
        if (parameterValues == null) {
            this.parameterValues = null;
            return;
        }
        this.parameterValues = new SdkInternalList<ParameterValue>(parameterValues);
    }

    public ActivatePipelineRequest withParameterValues(ParameterValue ... parameterValues) {
        if (this.parameterValues == null) {
            this.setParameterValues(new SdkInternalList<ParameterValue>(parameterValues.length));
        }
        for (ParameterValue ele : parameterValues) {
            this.parameterValues.add(ele);
        }
        return this;
    }

    public ActivatePipelineRequest withParameterValues(Collection<ParameterValue> parameterValues) {
        this.setParameterValues(parameterValues);
        return this;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public ActivatePipelineRequest withStartTimestamp(Date startTimestamp) {
        this.setStartTimestamp(startTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: ").append(this.getPipelineId()).append(",");
        }
        if (this.getParameterValues() != null) {
            sb.append("ParameterValues: ").append(this.getParameterValues()).append(",");
        }
        if (this.getStartTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.getStartTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatePipelineRequest)) {
            return false;
        }
        ActivatePipelineRequest other = (ActivatePipelineRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getParameterValues() == null ^ this.getParameterValues() == null) {
            return false;
        }
        if (other.getParameterValues() != null && !other.getParameterValues().equals(this.getParameterValues())) {
            return false;
        }
        if (other.getStartTimestamp() == null ^ this.getStartTimestamp() == null) {
            return false;
        }
        return other.getStartTimestamp() == null || other.getStartTimestamp().equals(this.getStartTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getParameterValues() == null ? 0 : this.getParameterValues().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestamp() == null ? 0 : this.getStartTimestamp().hashCode());
        return hashCode;
    }

    @Override
    public ActivatePipelineRequest clone() {
        return (ActivatePipelineRequest)super.clone();
    }
}

