/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dax.model.Endpoint;
import com.amazonaws.services.dax.model.Node;
import com.amazonaws.services.dax.model.NotificationConfiguration;
import com.amazonaws.services.dax.model.ParameterGroupStatus;
import com.amazonaws.services.dax.model.SecurityGroupMembership;
import com.amazonaws.services.dax.model.transform.ClusterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Cluster
implements Serializable,
Cloneable,
StructuredPojo {
    private String clusterName;
    private String description;
    private String clusterArn;
    private Integer totalNodes;
    private Integer activeNodes;
    private String nodeType;
    private String status;
    private Endpoint clusterDiscoveryEndpoint;
    private List<String> nodeIdsToRemove;
    private List<Node> nodes;
    private String preferredMaintenanceWindow;
    private NotificationConfiguration notificationConfiguration;
    private String subnetGroup;
    private List<SecurityGroupMembership> securityGroups;
    private String iamRoleArn;
    private ParameterGroupStatus parameterGroup;

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Cluster withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Cluster withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public Cluster withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public void setTotalNodes(Integer totalNodes) {
        this.totalNodes = totalNodes;
    }

    public Integer getTotalNodes() {
        return this.totalNodes;
    }

    public Cluster withTotalNodes(Integer totalNodes) {
        this.setTotalNodes(totalNodes);
        return this;
    }

    public void setActiveNodes(Integer activeNodes) {
        this.activeNodes = activeNodes;
    }

    public Integer getActiveNodes() {
        return this.activeNodes;
    }

    public Cluster withActiveNodes(Integer activeNodes) {
        this.setActiveNodes(activeNodes);
        return this;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public Cluster withNodeType(String nodeType) {
        this.setNodeType(nodeType);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Cluster withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setClusterDiscoveryEndpoint(Endpoint clusterDiscoveryEndpoint) {
        this.clusterDiscoveryEndpoint = clusterDiscoveryEndpoint;
    }

    public Endpoint getClusterDiscoveryEndpoint() {
        return this.clusterDiscoveryEndpoint;
    }

    public Cluster withClusterDiscoveryEndpoint(Endpoint clusterDiscoveryEndpoint) {
        this.setClusterDiscoveryEndpoint(clusterDiscoveryEndpoint);
        return this;
    }

    public List<String> getNodeIdsToRemove() {
        return this.nodeIdsToRemove;
    }

    public void setNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
        if (nodeIdsToRemove == null) {
            this.nodeIdsToRemove = null;
            return;
        }
        this.nodeIdsToRemove = new ArrayList<String>(nodeIdsToRemove);
    }

    public Cluster withNodeIdsToRemove(String ... nodeIdsToRemove) {
        if (this.nodeIdsToRemove == null) {
            this.setNodeIdsToRemove(new ArrayList<String>(nodeIdsToRemove.length));
        }
        for (String ele : nodeIdsToRemove) {
            this.nodeIdsToRemove.add(ele);
        }
        return this;
    }

    public Cluster withNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
        this.setNodeIdsToRemove(nodeIdsToRemove);
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Collection<Node> nodes) {
        if (nodes == null) {
            this.nodes = null;
            return;
        }
        this.nodes = new ArrayList<Node>(nodes);
    }

    public Cluster withNodes(Node ... nodes) {
        if (this.nodes == null) {
            this.setNodes(new ArrayList<Node>(nodes.length));
        }
        for (Node ele : nodes) {
            this.nodes.add(ele);
        }
        return this;
    }

    public Cluster withNodes(Collection<Node> nodes) {
        this.setNodes(nodes);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Cluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    public Cluster withNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.setNotificationConfiguration(notificationConfiguration);
        return this;
    }

    public void setSubnetGroup(String subnetGroup) {
        this.subnetGroup = subnetGroup;
    }

    public String getSubnetGroup() {
        return this.subnetGroup;
    }

    public Cluster withSubnetGroup(String subnetGroup) {
        this.setSubnetGroup(subnetGroup);
        return this;
    }

    public List<SecurityGroupMembership> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<SecurityGroupMembership>(securityGroups);
    }

    public Cluster withSecurityGroups(SecurityGroupMembership ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<SecurityGroupMembership>(securityGroups.length));
        }
        for (SecurityGroupMembership ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public Cluster withSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setIamRoleArn(String iamRoleArn) {
        this.iamRoleArn = iamRoleArn;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public Cluster withIamRoleArn(String iamRoleArn) {
        this.setIamRoleArn(iamRoleArn);
        return this;
    }

    public void setParameterGroup(ParameterGroupStatus parameterGroup) {
        this.parameterGroup = parameterGroup;
    }

    public ParameterGroupStatus getParameterGroup() {
        return this.parameterGroup;
    }

    public Cluster withParameterGroup(ParameterGroupStatus parameterGroup) {
        this.setParameterGroup(parameterGroup);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: ").append(this.getClusterArn()).append(",");
        }
        if (this.getTotalNodes() != null) {
            sb.append("TotalNodes: ").append(this.getTotalNodes()).append(",");
        }
        if (this.getActiveNodes() != null) {
            sb.append("ActiveNodes: ").append(this.getActiveNodes()).append(",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: ").append(this.getNodeType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getClusterDiscoveryEndpoint() != null) {
            sb.append("ClusterDiscoveryEndpoint: ").append(this.getClusterDiscoveryEndpoint()).append(",");
        }
        if (this.getNodeIdsToRemove() != null) {
            sb.append("NodeIdsToRemove: ").append(this.getNodeIdsToRemove()).append(",");
        }
        if (this.getNodes() != null) {
            sb.append("Nodes: ").append(this.getNodes()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getNotificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.getNotificationConfiguration()).append(",");
        }
        if (this.getSubnetGroup() != null) {
            sb.append("SubnetGroup: ").append(this.getSubnetGroup()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getIamRoleArn() != null) {
            sb.append("IamRoleArn: ").append(this.getIamRoleArn()).append(",");
        }
        if (this.getParameterGroup() != null) {
            sb.append("ParameterGroup: ").append(this.getParameterGroup());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getTotalNodes() == null ^ this.getTotalNodes() == null) {
            return false;
        }
        if (other.getTotalNodes() != null && !other.getTotalNodes().equals(this.getTotalNodes())) {
            return false;
        }
        if (other.getActiveNodes() == null ^ this.getActiveNodes() == null) {
            return false;
        }
        if (other.getActiveNodes() != null && !other.getActiveNodes().equals(this.getActiveNodes())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getClusterDiscoveryEndpoint() == null ^ this.getClusterDiscoveryEndpoint() == null) {
            return false;
        }
        if (other.getClusterDiscoveryEndpoint() != null && !other.getClusterDiscoveryEndpoint().equals(this.getClusterDiscoveryEndpoint())) {
            return false;
        }
        if (other.getNodeIdsToRemove() == null ^ this.getNodeIdsToRemove() == null) {
            return false;
        }
        if (other.getNodeIdsToRemove() != null && !other.getNodeIdsToRemove().equals(this.getNodeIdsToRemove())) {
            return false;
        }
        if (other.getNodes() == null ^ this.getNodes() == null) {
            return false;
        }
        if (other.getNodes() != null && !other.getNodes().equals(this.getNodes())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getNotificationConfiguration() == null ^ this.getNotificationConfiguration() == null) {
            return false;
        }
        if (other.getNotificationConfiguration() != null && !other.getNotificationConfiguration().equals(this.getNotificationConfiguration())) {
            return false;
        }
        if (other.getSubnetGroup() == null ^ this.getSubnetGroup() == null) {
            return false;
        }
        if (other.getSubnetGroup() != null && !other.getSubnetGroup().equals(this.getSubnetGroup())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getIamRoleArn() == null ^ this.getIamRoleArn() == null) {
            return false;
        }
        if (other.getIamRoleArn() != null && !other.getIamRoleArn().equals(this.getIamRoleArn())) {
            return false;
        }
        if (other.getParameterGroup() == null ^ this.getParameterGroup() == null) {
            return false;
        }
        return other.getParameterGroup() == null || other.getParameterGroup().equals(this.getParameterGroup());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getTotalNodes() == null ? 0 : this.getTotalNodes().hashCode());
        hashCode = 31 * hashCode + (this.getActiveNodes() == null ? 0 : this.getActiveNodes().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClusterDiscoveryEndpoint() == null ? 0 : this.getClusterDiscoveryEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getNodeIdsToRemove() == null ? 0 : this.getNodeIdsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getNodes() == null ? 0 : this.getNodes().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationConfiguration() == null ? 0 : this.getNotificationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetGroup() == null ? 0 : this.getSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoleArn() == null ? 0 : this.getIamRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getParameterGroup() == null ? 0 : this.getParameterGroup().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

