/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowResourceType;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RegisterTargetWithMaintenanceWindowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String windowId;
    private String resourceType;
    private SdkInternalList<Target> targets;
    private String ownerInformation;
    private String clientToken;

    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public RegisterTargetWithMaintenanceWindowRequest withWindowId(String windowId) {
        this.setWindowId(windowId);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public RegisterTargetWithMaintenanceWindowRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceType(MaintenanceWindowResourceType resourceType) {
        this.withResourceType(resourceType);
    }

    public RegisterTargetWithMaintenanceWindowRequest withResourceType(MaintenanceWindowResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList<Target>(targets);
    }

    public RegisterTargetWithMaintenanceWindowRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new SdkInternalList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public RegisterTargetWithMaintenanceWindowRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setOwnerInformation(String ownerInformation) {
        this.ownerInformation = ownerInformation;
    }

    public String getOwnerInformation() {
        return this.ownerInformation;
    }

    public RegisterTargetWithMaintenanceWindowRequest withOwnerInformation(String ownerInformation) {
        this.setOwnerInformation(ownerInformation);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public RegisterTargetWithMaintenanceWindowRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWindowId() != null) {
            sb.append("WindowId: ").append(this.getWindowId()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getOwnerInformation() != null) {
            sb.append("OwnerInformation: ").append(this.getOwnerInformation()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTargetWithMaintenanceWindowRequest other = (RegisterTargetWithMaintenanceWindowRequest)obj;
        if (other.getWindowId() == null ^ this.getWindowId() == null) {
            return false;
        }
        if (other.getWindowId() != null && !other.getWindowId().equals(this.getWindowId())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getOwnerInformation() == null ^ this.getOwnerInformation() == null) {
            return false;
        }
        if (other.getOwnerInformation() != null && !other.getOwnerInformation().equals(this.getOwnerInformation())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWindowId() == null ? 0 : this.getWindowId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerInformation() == null ? 0 : this.getOwnerInformation().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public RegisterTargetWithMaintenanceWindowRequest clone() {
        return (RegisterTargetWithMaintenanceWindowRequest)super.clone();
    }
}

