/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.BoundingBox;
import com.amazonaws.services.rekognition.model.ImageQuality;
import com.amazonaws.services.rekognition.model.Landmark;
import com.amazonaws.services.rekognition.model.Pose;
import com.amazonaws.services.rekognition.model.transform.ComparedFaceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComparedFace
implements Serializable,
Cloneable,
StructuredPojo {
    private BoundingBox boundingBox;
    private Float confidence;
    private List<Landmark> landmarks;
    private Pose pose;
    private ImageQuality quality;

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public ComparedFace withBoundingBox(BoundingBox boundingBox) {
        this.setBoundingBox(boundingBox);
        return this;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public ComparedFace withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public List<Landmark> getLandmarks() {
        return this.landmarks;
    }

    public void setLandmarks(Collection<Landmark> landmarks) {
        if (landmarks == null) {
            this.landmarks = null;
            return;
        }
        this.landmarks = new ArrayList<Landmark>(landmarks);
    }

    public ComparedFace withLandmarks(Landmark ... landmarks) {
        if (this.landmarks == null) {
            this.setLandmarks(new ArrayList<Landmark>(landmarks.length));
        }
        for (Landmark ele : landmarks) {
            this.landmarks.add(ele);
        }
        return this;
    }

    public ComparedFace withLandmarks(Collection<Landmark> landmarks) {
        this.setLandmarks(landmarks);
        return this;
    }

    public void setPose(Pose pose) {
        this.pose = pose;
    }

    public Pose getPose() {
        return this.pose;
    }

    public ComparedFace withPose(Pose pose) {
        this.setPose(pose);
        return this;
    }

    public void setQuality(ImageQuality quality) {
        this.quality = quality;
    }

    public ImageQuality getQuality() {
        return this.quality;
    }

    public ComparedFace withQuality(ImageQuality quality) {
        this.setQuality(quality);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBoundingBox() != null) {
            sb.append("BoundingBox: ").append(this.getBoundingBox()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getLandmarks() != null) {
            sb.append("Landmarks: ").append(this.getLandmarks()).append(",");
        }
        if (this.getPose() != null) {
            sb.append("Pose: ").append(this.getPose()).append(",");
        }
        if (this.getQuality() != null) {
            sb.append("Quality: ").append(this.getQuality());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparedFace)) {
            return false;
        }
        ComparedFace other = (ComparedFace)obj;
        if (other.getBoundingBox() == null ^ this.getBoundingBox() == null) {
            return false;
        }
        if (other.getBoundingBox() != null && !other.getBoundingBox().equals(this.getBoundingBox())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getLandmarks() == null ^ this.getLandmarks() == null) {
            return false;
        }
        if (other.getLandmarks() != null && !other.getLandmarks().equals(this.getLandmarks())) {
            return false;
        }
        if (other.getPose() == null ^ this.getPose() == null) {
            return false;
        }
        if (other.getPose() != null && !other.getPose().equals(this.getPose())) {
            return false;
        }
        if (other.getQuality() == null ^ this.getQuality() == null) {
            return false;
        }
        return other.getQuality() == null || other.getQuality().equals(this.getQuality());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBoundingBox() == null ? 0 : this.getBoundingBox().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getLandmarks() == null ? 0 : this.getLandmarks().hashCode());
        hashCode = 31 * hashCode + (this.getPose() == null ? 0 : this.getPose().hashCode());
        hashCode = 31 * hashCode + (this.getQuality() == null ? 0 : this.getQuality().hashCode());
        return hashCode;
    }

    public ComparedFace clone() {
        try {
            return (ComparedFace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComparedFaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

