/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.Topic;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TopicStaxUnmarshaller
implements Unmarshaller<Topic, StaxUnmarshallerContext> {
    private static TopicStaxUnmarshaller instance;

    @Override
    public Topic unmarshall(StaxUnmarshallerContext context) throws Exception {
        Topic topic = new Topic();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return topic;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("TopicArn", targetDepth)) continue;
                topic.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return topic;
    }

    public static TopicStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TopicStaxUnmarshaller();
        }
        return instance;
    }
}

