/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    @Override
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        SdkInternalList metricDataList;
        if (putMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMetricDataRequest> request = new DefaultRequest<PutMetricDataRequest>(putMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricDataRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putMetricDataRequest.getNamespace()));
        }
        if (!(metricDataList = (SdkInternalList)putMetricDataRequest.getMetricData()).isEmpty() || !metricDataList.isAutoConstruct()) {
            int metricDataListIndex = 1;
            for (MetricDatum metricDataListValue : metricDataList) {
                StatisticSet statisticValues;
                SdkInternalList dimensionsList;
                if (metricDataListValue.getMetricName() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName", StringUtils.fromString(metricDataListValue.getMetricName()));
                }
                if (!(dimensionsList = (SdkInternalList)metricDataListValue.getDimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
                    int dimensionsListIndex = 1;
                    for (Dimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue.getName() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                        }
                        if (dimensionsListValue.getValue() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (metricDataListValue.getTimestamp() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp", StringUtils.fromDate(metricDataListValue.getTimestamp()));
                }
                if (metricDataListValue.getValue() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Value", StringUtils.fromDouble(metricDataListValue.getValue()));
                }
                if ((statisticValues = metricDataListValue.getStatisticValues()) != null) {
                    if (statisticValues.getSampleCount() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount", StringUtils.fromDouble(statisticValues.getSampleCount()));
                    }
                    if (statisticValues.getSum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum", StringUtils.fromDouble(statisticValues.getSum()));
                    }
                    if (statisticValues.getMinimum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum", StringUtils.fromDouble(statisticValues.getMinimum()));
                    }
                    if (statisticValues.getMaximum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum", StringUtils.fromDouble(statisticValues.getMaximum()));
                    }
                }
                if (metricDataListValue.getUnit() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Unit", StringUtils.fromString(metricDataListValue.getUnit()));
                }
                ++metricDataListIndex;
            }
        }
        return request;
    }
}

