/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DeleteAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private String itemName;
    private SdkInternalList<Attribute> attributes;
    private UpdateCondition expected;

    public DeleteAttributesRequest() {
    }

    public DeleteAttributesRequest(String domainName, String itemName) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
    }

    public DeleteAttributesRequest(String domainName, String itemName, List<Attribute> attributes) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
    }

    public DeleteAttributesRequest(String domainName, String itemName, List<Attribute> attributes, UpdateCondition expected) {
        this.setDomainName(domainName);
        this.setItemName(itemName);
        this.setAttributes(attributes);
        this.setExpected(expected);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DeleteAttributesRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public DeleteAttributesRequest withItemName(String itemName) {
        this.setItemName(itemName);
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalList();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new SdkInternalList<Attribute>(attributes);
    }

    public DeleteAttributesRequest withAttributes(Attribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new SdkInternalList<Attribute>(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public DeleteAttributesRequest withAttributes(Collection<Attribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void setExpected(UpdateCondition expected) {
        this.expected = expected;
    }

    public UpdateCondition getExpected() {
        return this.expected;
    }

    public DeleteAttributesRequest withExpected(UpdateCondition expected) {
        this.setExpected(expected);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getItemName() != null) {
            sb.append("ItemName: ").append(this.getItemName()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getExpected() != null) {
            sb.append("Expected: ").append(this.getExpected());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAttributesRequest)) {
            return false;
        }
        DeleteAttributesRequest other = (DeleteAttributesRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getItemName() == null ^ this.getItemName() == null) {
            return false;
        }
        if (other.getItemName() != null && !other.getItemName().equals(this.getItemName())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        return other.getExpected() == null || other.getExpected().equals(this.getExpected());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getItemName() == null ? 0 : this.getItemName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getExpected() == null ? 0 : this.getExpected().hashCode());
        return hashCode;
    }

    @Override
    public DeleteAttributesRequest clone() {
        return (DeleteAttributesRequest)super.clone();
    }
}

