/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.CloudwatchAlarmAction;

@SdkInternalApi
public class CloudwatchAlarmActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> ALARMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alarmName").build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateReason").build();
    private static final MarshallingInfo<String> STATEVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stateValue").build();
    private static final CloudwatchAlarmActionMarshaller instance = new CloudwatchAlarmActionMarshaller();

    public static CloudwatchAlarmActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudwatchAlarmAction cloudwatchAlarmAction, ProtocolMarshaller protocolMarshaller) {
        if (cloudwatchAlarmAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cloudwatchAlarmAction.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(cloudwatchAlarmAction.getAlarmName(), ALARMNAME_BINDING);
            protocolMarshaller.marshall(cloudwatchAlarmAction.getStateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall(cloudwatchAlarmAction.getStateValue(), STATEVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

