/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class InstanceRunning {
    InstanceRunning() {
    }

    static class IsInvalidInstanceIDNotFoundMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        IsInvalidInstanceIDNotFoundMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "InvalidInstanceID.NotFound".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsStoppingMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsStoppingMatcher() {
        }

        @Override
        public boolean matches(DescribeInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"stopping\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Reservations")), new JmesPathField("Instances"))), new JmesPathSubExpression(new JmesPathField("State"), new JmesPathField("Name")));
        }
    }

    static class IsTerminatedMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsTerminatedMatcher() {
        }

        @Override
        public boolean matches(DescribeInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"terminated\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Reservations")), new JmesPathField("Instances"))), new JmesPathSubExpression(new JmesPathField("State"), new JmesPathField("Name")));
        }
    }

    static class IsShuttingdownMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsShuttingdownMatcher() {
        }

        @Override
        public boolean matches(DescribeInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"shutting-down\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Reservations")), new JmesPathField("Instances"))), new JmesPathSubExpression(new JmesPathField("State"), new JmesPathField("Name")));
        }
    }

    static class IsRunningMatcher
    extends WaiterAcceptor<DescribeInstancesResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsRunningMatcher() {
        }

        @Override
        public boolean matches(DescribeInstancesResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"running\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Reservations")), new JmesPathField("Instances"))), new JmesPathSubExpression(new JmesPathField("State"), new JmesPathField("Name")));
        }
    }
}

