/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.FaceRecord;
import com.amazonaws.services.rekognition.model.OrientationCorrection;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IndexFacesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FaceRecord> faceRecords;
    private String orientationCorrection;

    public List<FaceRecord> getFaceRecords() {
        return this.faceRecords;
    }

    public void setFaceRecords(Collection<FaceRecord> faceRecords) {
        if (faceRecords == null) {
            this.faceRecords = null;
            return;
        }
        this.faceRecords = new ArrayList<FaceRecord>(faceRecords);
    }

    public IndexFacesResult withFaceRecords(FaceRecord ... faceRecords) {
        if (this.faceRecords == null) {
            this.setFaceRecords(new ArrayList<FaceRecord>(faceRecords.length));
        }
        for (FaceRecord ele : faceRecords) {
            this.faceRecords.add(ele);
        }
        return this;
    }

    public IndexFacesResult withFaceRecords(Collection<FaceRecord> faceRecords) {
        this.setFaceRecords(faceRecords);
        return this;
    }

    public void setOrientationCorrection(String orientationCorrection) {
        this.orientationCorrection = orientationCorrection;
    }

    public String getOrientationCorrection() {
        return this.orientationCorrection;
    }

    public IndexFacesResult withOrientationCorrection(String orientationCorrection) {
        this.setOrientationCorrection(orientationCorrection);
        return this;
    }

    @JsonIgnore
    public void setOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.orientationCorrection = orientationCorrection.toString();
    }

    public IndexFacesResult withOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.setOrientationCorrection(orientationCorrection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFaceRecords() != null) {
            sb.append("FaceRecords: ").append(this.getFaceRecords()).append(",");
        }
        if (this.getOrientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.getOrientationCorrection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesResult)) {
            return false;
        }
        IndexFacesResult other = (IndexFacesResult)obj;
        if (other.getFaceRecords() == null ^ this.getFaceRecords() == null) {
            return false;
        }
        if (other.getFaceRecords() != null && !other.getFaceRecords().equals(this.getFaceRecords())) {
            return false;
        }
        if (other.getOrientationCorrection() == null ^ this.getOrientationCorrection() == null) {
            return false;
        }
        return other.getOrientationCorrection() == null || other.getOrientationCorrection().equals(this.getOrientationCorrection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFaceRecords() == null ? 0 : this.getFaceRecords().hashCode());
        hashCode = 31 * hashCode + (this.getOrientationCorrection() == null ? 0 : this.getOrientationCorrection().hashCode());
        return hashCode;
    }

    public IndexFacesResult clone() {
        try {
            return (IndexFacesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

