/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.rekognition.model.Label;
import com.amazonaws.services.rekognition.model.OrientationCorrection;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectLabelsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Label> labels;
    private String orientationCorrection;

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<Label> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<Label>(labels);
    }

    public DetectLabelsResult withLabels(Label ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<Label>(labels.length));
        }
        for (Label ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public DetectLabelsResult withLabels(Collection<Label> labels) {
        this.setLabels(labels);
        return this;
    }

    public void setOrientationCorrection(String orientationCorrection) {
        this.orientationCorrection = orientationCorrection;
    }

    public String getOrientationCorrection() {
        return this.orientationCorrection;
    }

    public DetectLabelsResult withOrientationCorrection(String orientationCorrection) {
        this.setOrientationCorrection(orientationCorrection);
        return this;
    }

    @JsonIgnore
    public void setOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.orientationCorrection = orientationCorrection.toString();
    }

    public DetectLabelsResult withOrientationCorrection(OrientationCorrection orientationCorrection) {
        this.setOrientationCorrection(orientationCorrection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getOrientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(this.getOrientationCorrection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResult)) {
            return false;
        }
        DetectLabelsResult other = (DetectLabelsResult)obj;
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getOrientationCorrection() == null ^ this.getOrientationCorrection() == null) {
            return false;
        }
        return other.getOrientationCorrection() == null || other.getOrientationCorrection().equals(this.getOrientationCorrection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getOrientationCorrection() == null ? 0 : this.getOrientationCorrection().hashCode());
        return hashCode;
    }

    public DetectLabelsResult clone() {
        try {
            return (DetectLabelsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

