/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ResetImageAttributeName;
import com.amazonaws.services.ec2.model.transform.ResetImageAttributeRequestMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;

public class ResetImageAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ResetImageAttributeRequest> {
    private String imageId;
    private String attribute;

    public ResetImageAttributeRequest() {
    }

    public ResetImageAttributeRequest(String imageId, String attribute) {
        this.setImageId(imageId);
        this.setAttribute(attribute);
    }

    public ResetImageAttributeRequest(String imageId, ResetImageAttributeName attribute) {
        this.setImageId(imageId);
        this.setAttribute(attribute.toString());
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public ResetImageAttributeRequest withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ResetImageAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @JsonIgnore
    public void setAttribute(ResetImageAttributeName attribute) {
        this.attribute = attribute.toString();
    }

    public ResetImageAttributeRequest withAttribute(ResetImageAttributeName attribute) {
        this.setAttribute(attribute);
        return this;
    }

    @Override
    public Request<ResetImageAttributeRequest> getDryRunRequest() {
        Request<ResetImageAttributeRequest> request = new ResetImageAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetImageAttributeRequest)) {
            return false;
        }
        ResetImageAttributeRequest other = (ResetImageAttributeRequest)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        return other.getAttribute() == null || other.getAttribute().equals(this.getAttribute());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        return hashCode;
    }

    @Override
    public ResetImageAttributeRequest clone() {
        return (ResetImageAttributeRequest)super.clone();
    }
}

