/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ReportInstanceReasonCodes;
import com.amazonaws.services.ec2.model.ReportStatusType;
import com.amazonaws.services.ec2.model.transform.ReportInstanceStatusRequestMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ReportInstanceStatusRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ReportInstanceStatusRequest> {
    private SdkInternalList<String> instances;
    private String status;
    private Date startTime;
    private Date endTime;
    private SdkInternalList<String> reasonCodes;
    private String description;

    public List<String> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<String> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList<String>(instances);
    }

    public ReportInstanceStatusRequest withInstances(String ... instances) {
        if (this.instances == null) {
            this.setInstances(new SdkInternalList<String>(instances.length));
        }
        for (String ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public ReportInstanceStatusRequest withInstances(Collection<String> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ReportInstanceStatusRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(ReportStatusType status) {
        this.status = status.toString();
    }

    public ReportInstanceStatusRequest withStatus(ReportStatusType status) {
        this.setStatus(status);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ReportInstanceStatusRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public ReportInstanceStatusRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public List<String> getReasonCodes() {
        if (this.reasonCodes == null) {
            this.reasonCodes = new SdkInternalList();
        }
        return this.reasonCodes;
    }

    public void setReasonCodes(Collection<String> reasonCodes) {
        if (reasonCodes == null) {
            this.reasonCodes = null;
            return;
        }
        this.reasonCodes = new SdkInternalList<String>(reasonCodes);
    }

    public ReportInstanceStatusRequest withReasonCodes(String ... reasonCodes) {
        if (this.reasonCodes == null) {
            this.setReasonCodes(new SdkInternalList<String>(reasonCodes.length));
        }
        for (String ele : reasonCodes) {
            this.reasonCodes.add(ele);
        }
        return this;
    }

    public ReportInstanceStatusRequest withReasonCodes(Collection<String> reasonCodes) {
        this.setReasonCodes(reasonCodes);
        return this;
    }

    public ReportInstanceStatusRequest withReasonCodes(ReportInstanceReasonCodes ... reasonCodes) {
        SdkInternalList<String> reasonCodesCopy = new SdkInternalList<String>(reasonCodes.length);
        for (ReportInstanceReasonCodes value : reasonCodes) {
            reasonCodesCopy.add(value.toString());
        }
        if (this.getReasonCodes() == null) {
            this.setReasonCodes(reasonCodesCopy);
        } else {
            this.getReasonCodes().addAll(reasonCodesCopy);
        }
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ReportInstanceStatusRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    public Request<ReportInstanceStatusRequest> getDryRunRequest() {
        Request<ReportInstanceStatusRequest> request = new ReportInstanceStatusRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getReasonCodes() != null) {
            sb.append("ReasonCodes: ").append(this.getReasonCodes()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getReasonCodes() == null ^ this.getReasonCodes() == null) {
            return false;
        }
        if (other.getReasonCodes() != null && !other.getReasonCodes().equals(this.getReasonCodes())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getReasonCodes() == null ? 0 : this.getReasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    @Override
    public ReportInstanceStatusRequest clone() {
        return (ReportInstanceStatusRequest)super.clone();
    }
}

