/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.MFAOptionType;
import com.amazonaws.services.cognitoidp.model.UserStatusType;
import com.amazonaws.services.cognitoidp.model.transform.UserTypeMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UserType
implements Serializable,
Cloneable,
StructuredPojo {
    private String username;
    private List<AttributeType> attributes;
    private Date userCreateDate;
    private Date userLastModifiedDate;
    private Boolean enabled;
    private String userStatus;
    private List<MFAOptionType> mFAOptions;

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public UserType withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public List<AttributeType> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<AttributeType> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<AttributeType>(attributes);
    }

    public UserType withAttributes(AttributeType ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<AttributeType>(attributes.length));
        }
        for (AttributeType ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public UserType withAttributes(Collection<AttributeType> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void setUserCreateDate(Date userCreateDate) {
        this.userCreateDate = userCreateDate;
    }

    public Date getUserCreateDate() {
        return this.userCreateDate;
    }

    public UserType withUserCreateDate(Date userCreateDate) {
        this.setUserCreateDate(userCreateDate);
        return this;
    }

    public void setUserLastModifiedDate(Date userLastModifiedDate) {
        this.userLastModifiedDate = userLastModifiedDate;
    }

    public Date getUserLastModifiedDate() {
        return this.userLastModifiedDate;
    }

    public UserType withUserLastModifiedDate(Date userLastModifiedDate) {
        this.setUserLastModifiedDate(userLastModifiedDate);
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public UserType withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setUserStatus(String userStatus) {
        this.userStatus = userStatus;
    }

    public String getUserStatus() {
        return this.userStatus;
    }

    public UserType withUserStatus(String userStatus) {
        this.setUserStatus(userStatus);
        return this;
    }

    @JsonIgnore
    public void setUserStatus(UserStatusType userStatus) {
        this.userStatus = userStatus.toString();
    }

    public UserType withUserStatus(UserStatusType userStatus) {
        this.setUserStatus(userStatus);
        return this;
    }

    public List<MFAOptionType> getMFAOptions() {
        return this.mFAOptions;
    }

    public void setMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
            return;
        }
        this.mFAOptions = new ArrayList<MFAOptionType>(mFAOptions);
    }

    public UserType withMFAOptions(MFAOptionType ... mFAOptions) {
        if (this.mFAOptions == null) {
            this.setMFAOptions(new ArrayList<MFAOptionType>(mFAOptions.length));
        }
        for (MFAOptionType ele : mFAOptions) {
            this.mFAOptions.add(ele);
        }
        return this;
    }

    public UserType withMFAOptions(Collection<MFAOptionType> mFAOptions) {
        this.setMFAOptions(mFAOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getUserCreateDate() != null) {
            sb.append("UserCreateDate: ").append(this.getUserCreateDate()).append(",");
        }
        if (this.getUserLastModifiedDate() != null) {
            sb.append("UserLastModifiedDate: ").append(this.getUserLastModifiedDate()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getUserStatus() != null) {
            sb.append("UserStatus: ").append(this.getUserStatus()).append(",");
        }
        if (this.getMFAOptions() != null) {
            sb.append("MFAOptions: ").append(this.getMFAOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getUserCreateDate() == null ^ this.getUserCreateDate() == null) {
            return false;
        }
        if (other.getUserCreateDate() != null && !other.getUserCreateDate().equals(this.getUserCreateDate())) {
            return false;
        }
        if (other.getUserLastModifiedDate() == null ^ this.getUserLastModifiedDate() == null) {
            return false;
        }
        if (other.getUserLastModifiedDate() != null && !other.getUserLastModifiedDate().equals(this.getUserLastModifiedDate())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getUserStatus() == null ^ this.getUserStatus() == null) {
            return false;
        }
        if (other.getUserStatus() != null && !other.getUserStatus().equals(this.getUserStatus())) {
            return false;
        }
        if (other.getMFAOptions() == null ^ this.getMFAOptions() == null) {
            return false;
        }
        return other.getMFAOptions() == null || other.getMFAOptions().equals(this.getMFAOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getUserCreateDate() == null ? 0 : this.getUserCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getUserLastModifiedDate() == null ? 0 : this.getUserLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getUserStatus() == null ? 0 : this.getUserStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMFAOptions() == null ? 0 : this.getMFAOptions().hashCode());
        return hashCode;
    }

    public UserType clone() {
        try {
            return (UserType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

