/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackStatus;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Stack
implements Serializable,
Cloneable {
    private String stackId;
    private String stackName;
    private String changeSetId;
    private String description;
    private SdkInternalList<Parameter> parameters;
    private Date creationTime;
    private Date lastUpdatedTime;
    private String stackStatus;
    private String stackStatusReason;
    private Boolean disableRollback;
    private SdkInternalList<String> notificationARNs;
    private Integer timeoutInMinutes;
    private SdkInternalList<String> capabilities;
    private SdkInternalList<Output> outputs;
    private String roleARN;
    private SdkInternalList<Tag> tags;

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public Stack withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getStackName() {
        return this.stackName;
    }

    public Stack withStackName(String stackName) {
        this.setStackName(stackName);
        return this;
    }

    public void setChangeSetId(String changeSetId) {
        this.changeSetId = changeSetId;
    }

    public String getChangeSetId() {
        return this.changeSetId;
    }

    public Stack withChangeSetId(String changeSetId) {
        this.setChangeSetId(changeSetId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Stack withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new SdkInternalList();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new SdkInternalList<Parameter>(parameters);
    }

    public Stack withParameters(Parameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new SdkInternalList<Parameter>(parameters.length));
        }
        for (Parameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public Stack withParameters(Collection<Parameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Stack withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Stack withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setStackStatus(String stackStatus) {
        this.stackStatus = stackStatus;
    }

    public String getStackStatus() {
        return this.stackStatus;
    }

    public Stack withStackStatus(String stackStatus) {
        this.setStackStatus(stackStatus);
        return this;
    }

    @JsonIgnore
    public void setStackStatus(StackStatus stackStatus) {
        this.stackStatus = stackStatus.toString();
    }

    public Stack withStackStatus(StackStatus stackStatus) {
        this.setStackStatus(stackStatus);
        return this;
    }

    public void setStackStatusReason(String stackStatusReason) {
        this.stackStatusReason = stackStatusReason;
    }

    public String getStackStatusReason() {
        return this.stackStatusReason;
    }

    public Stack withStackStatusReason(String stackStatusReason) {
        this.setStackStatusReason(stackStatusReason);
        return this;
    }

    public void setDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
    }

    public Boolean getDisableRollback() {
        return this.disableRollback;
    }

    public Stack withDisableRollback(Boolean disableRollback) {
        this.setDisableRollback(disableRollback);
        return this;
    }

    public Boolean isDisableRollback() {
        return this.disableRollback;
    }

    public List<String> getNotificationARNs() {
        if (this.notificationARNs == null) {
            this.notificationARNs = new SdkInternalList();
        }
        return this.notificationARNs;
    }

    public void setNotificationARNs(Collection<String> notificationARNs) {
        if (notificationARNs == null) {
            this.notificationARNs = null;
            return;
        }
        this.notificationARNs = new SdkInternalList<String>(notificationARNs);
    }

    public Stack withNotificationARNs(String ... notificationARNs) {
        if (this.notificationARNs == null) {
            this.setNotificationARNs(new SdkInternalList<String>(notificationARNs.length));
        }
        for (String ele : notificationARNs) {
            this.notificationARNs.add(ele);
        }
        return this;
    }

    public Stack withNotificationARNs(Collection<String> notificationARNs) {
        this.setNotificationARNs(notificationARNs);
        return this;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Stack withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new SdkInternalList();
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new SdkInternalList<String>(capabilities);
    }

    public Stack withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new SdkInternalList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public Stack withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public Stack withCapabilities(Capability ... capabilities) {
        SdkInternalList<String> capabilitiesCopy = new SdkInternalList<String>(capabilities.length);
        for (Capability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public List<Output> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new SdkInternalList();
        }
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new SdkInternalList<Output>(outputs);
    }

    public Stack withOutputs(Output ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new SdkInternalList<Output>(outputs.length));
        }
        for (Output ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public Stack withOutputs(Collection<Output> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public Stack withRoleARN(String roleARN) {
        this.setRoleARN(roleARN);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public Stack withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Stack withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: ").append(this.getStackId()).append(",");
        }
        if (this.getStackName() != null) {
            sb.append("StackName: ").append(this.getStackName()).append(",");
        }
        if (this.getChangeSetId() != null) {
            sb.append("ChangeSetId: ").append(this.getChangeSetId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getStackStatus() != null) {
            sb.append("StackStatus: ").append(this.getStackStatus()).append(",");
        }
        if (this.getStackStatusReason() != null) {
            sb.append("StackStatusReason: ").append(this.getStackStatusReason()).append(",");
        }
        if (this.getDisableRollback() != null) {
            sb.append("DisableRollback: ").append(this.getDisableRollback()).append(",");
        }
        if (this.getNotificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.getNotificationARNs()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getRoleARN() != null) {
            sb.append("RoleARN: ").append(this.getRoleARN()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getChangeSetId() == null ^ this.getChangeSetId() == null) {
            return false;
        }
        if (other.getChangeSetId() != null && !other.getChangeSetId().equals(this.getChangeSetId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getStackStatus() == null ^ this.getStackStatus() == null) {
            return false;
        }
        if (other.getStackStatus() != null && !other.getStackStatus().equals(this.getStackStatus())) {
            return false;
        }
        if (other.getStackStatusReason() == null ^ this.getStackStatusReason() == null) {
            return false;
        }
        if (other.getStackStatusReason() != null && !other.getStackStatusReason().equals(this.getStackStatusReason())) {
            return false;
        }
        if (other.getDisableRollback() == null ^ this.getDisableRollback() == null) {
            return false;
        }
        if (other.getDisableRollback() != null && !other.getDisableRollback().equals(this.getDisableRollback())) {
            return false;
        }
        if (other.getNotificationARNs() == null ^ this.getNotificationARNs() == null) {
            return false;
        }
        if (other.getNotificationARNs() != null && !other.getNotificationARNs().equals(this.getNotificationARNs())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getRoleARN() == null ^ this.getRoleARN() == null) {
            return false;
        }
        if (other.getRoleARN() != null && !other.getRoleARN().equals(this.getRoleARN())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getChangeSetId() == null ? 0 : this.getChangeSetId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getStackStatus() == null ? 0 : this.getStackStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStackStatusReason() == null ? 0 : this.getStackStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getDisableRollback() == null ? 0 : this.getDisableRollback().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationARNs() == null ? 0 : this.getNotificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getRoleARN() == null ? 0 : this.getRoleARN().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Stack clone() {
        try {
            return (Stack)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

