/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.Spend;

public class SpendJsonMarshaller {
    private static SpendJsonMarshaller instance;

    public void marshall(Spend spend, StructuredJsonGenerator jsonGenerator) {
        if (spend == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (spend.getAmount() != null) {
                jsonGenerator.writeFieldName("Amount").writeValue(spend.getAmount());
            }
            if (spend.getUnit() != null) {
                jsonGenerator.writeFieldName("Unit").writeValue(spend.getUnit());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SpendJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SpendJsonMarshaller();
        }
        return instance;
    }
}

