/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagentruntime.model.ExternalSource;
import com.amazonaws.services.bedrockagentruntime.model.ExternalSourcesGenerationConfiguration;
import com.amazonaws.services.bedrockagentruntime.model.transform.ExternalSourcesRetrieveAndGenerateConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExternalSourcesRetrieveAndGenerateConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private ExternalSourcesGenerationConfiguration generationConfiguration;
    private String modelArn;
    private List<ExternalSource> sources;

    public void setGenerationConfiguration(ExternalSourcesGenerationConfiguration generationConfiguration) {
        this.generationConfiguration = generationConfiguration;
    }

    public ExternalSourcesGenerationConfiguration getGenerationConfiguration() {
        return this.generationConfiguration;
    }

    public ExternalSourcesRetrieveAndGenerateConfiguration withGenerationConfiguration(ExternalSourcesGenerationConfiguration generationConfiguration) {
        this.setGenerationConfiguration(generationConfiguration);
        return this;
    }

    public void setModelArn(String modelArn) {
        this.modelArn = modelArn;
    }

    public String getModelArn() {
        return this.modelArn;
    }

    public ExternalSourcesRetrieveAndGenerateConfiguration withModelArn(String modelArn) {
        this.setModelArn(modelArn);
        return this;
    }

    public List<ExternalSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<ExternalSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<ExternalSource>(sources);
    }

    public ExternalSourcesRetrieveAndGenerateConfiguration withSources(ExternalSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<ExternalSource>(sources.length));
        }
        for (ExternalSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public ExternalSourcesRetrieveAndGenerateConfiguration withSources(Collection<ExternalSource> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGenerationConfiguration() != null) {
            sb.append("GenerationConfiguration: ").append(this.getGenerationConfiguration()).append(",");
        }
        if (this.getModelArn() != null) {
            sb.append("ModelArn: ").append(this.getModelArn()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourcesRetrieveAndGenerateConfiguration)) {
            return false;
        }
        ExternalSourcesRetrieveAndGenerateConfiguration other = (ExternalSourcesRetrieveAndGenerateConfiguration)obj;
        if (other.getGenerationConfiguration() == null ^ this.getGenerationConfiguration() == null) {
            return false;
        }
        if (other.getGenerationConfiguration() != null && !other.getGenerationConfiguration().equals(this.getGenerationConfiguration())) {
            return false;
        }
        if (other.getModelArn() == null ^ this.getModelArn() == null) {
            return false;
        }
        if (other.getModelArn() != null && !other.getModelArn().equals(this.getModelArn())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGenerationConfiguration() == null ? 0 : this.getGenerationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getModelArn() == null ? 0 : this.getModelArn().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public ExternalSourcesRetrieveAndGenerateConfiguration clone() {
        try {
            return (ExternalSourcesRetrieveAndGenerateConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExternalSourcesRetrieveAndGenerateConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

