/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.transform.PatternObjectFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PatternObjectFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> exclusionFilters;
    private List<String> inclusionFilters;
    private String objectType;

    public List<String> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(Collection<String> exclusionFilters) {
        if (exclusionFilters == null) {
            this.exclusionFilters = null;
            return;
        }
        this.exclusionFilters = new ArrayList<String>(exclusionFilters);
    }

    public PatternObjectFilter withExclusionFilters(String ... exclusionFilters) {
        if (this.exclusionFilters == null) {
            this.setExclusionFilters(new ArrayList<String>(exclusionFilters.length));
        }
        for (String ele : exclusionFilters) {
            this.exclusionFilters.add(ele);
        }
        return this;
    }

    public PatternObjectFilter withExclusionFilters(Collection<String> exclusionFilters) {
        this.setExclusionFilters(exclusionFilters);
        return this;
    }

    public List<String> getInclusionFilters() {
        return this.inclusionFilters;
    }

    public void setInclusionFilters(Collection<String> inclusionFilters) {
        if (inclusionFilters == null) {
            this.inclusionFilters = null;
            return;
        }
        this.inclusionFilters = new ArrayList<String>(inclusionFilters);
    }

    public PatternObjectFilter withInclusionFilters(String ... inclusionFilters) {
        if (this.inclusionFilters == null) {
            this.setInclusionFilters(new ArrayList<String>(inclusionFilters.length));
        }
        for (String ele : inclusionFilters) {
            this.inclusionFilters.add(ele);
        }
        return this;
    }

    public PatternObjectFilter withInclusionFilters(Collection<String> inclusionFilters) {
        this.setInclusionFilters(inclusionFilters);
        return this;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public PatternObjectFilter withObjectType(String objectType) {
        this.setObjectType(objectType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExclusionFilters() != null) {
            sb.append("ExclusionFilters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getInclusionFilters() != null) {
            sb.append("InclusionFilters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getObjectType() != null) {
            sb.append("ObjectType: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatternObjectFilter)) {
            return false;
        }
        PatternObjectFilter other = (PatternObjectFilter)obj;
        if (other.getExclusionFilters() == null ^ this.getExclusionFilters() == null) {
            return false;
        }
        if (other.getExclusionFilters() != null && !other.getExclusionFilters().equals(this.getExclusionFilters())) {
            return false;
        }
        if (other.getInclusionFilters() == null ^ this.getInclusionFilters() == null) {
            return false;
        }
        if (other.getInclusionFilters() != null && !other.getInclusionFilters().equals(this.getInclusionFilters())) {
            return false;
        }
        if (other.getObjectType() == null ^ this.getObjectType() == null) {
            return false;
        }
        return other.getObjectType() == null || other.getObjectType().equals(this.getObjectType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExclusionFilters() == null ? 0 : this.getExclusionFilters().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionFilters() == null ? 0 : this.getInclusionFilters().hashCode());
        hashCode = 31 * hashCode + (this.getObjectType() == null ? 0 : this.getObjectType().hashCode());
        return hashCode;
    }

    public PatternObjectFilter clone() {
        try {
            return (PatternObjectFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatternObjectFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

