/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.bedrockagent;

import javax.annotation.Generated;

import com.amazonaws.services.bedrockagent.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSBedrockAgent}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSBedrockAgent implements AWSBedrockAgent {

    protected AbstractAWSBedrockAgent() {
    }

    @Override
    public AssociateAgentKnowledgeBaseResult associateAgentKnowledgeBase(AssociateAgentKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAgentResult createAgent(CreateAgentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAgentActionGroupResult createAgentActionGroup(CreateAgentActionGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAgentAliasResult createAgentAlias(CreateAgentAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDataSourceResult createDataSource(CreateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlowResult createFlow(CreateFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlowAliasResult createFlowAlias(CreateFlowAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlowVersionResult createFlowVersion(CreateFlowVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateKnowledgeBaseResult createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePromptResult createPrompt(CreatePromptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePromptVersionResult createPromptVersion(CreatePromptVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAgentResult deleteAgent(DeleteAgentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAgentActionGroupResult deleteAgentActionGroup(DeleteAgentActionGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAgentAliasResult deleteAgentAlias(DeleteAgentAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAgentVersionResult deleteAgentVersion(DeleteAgentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDataSourceResult deleteDataSource(DeleteDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlowResult deleteFlow(DeleteFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlowAliasResult deleteFlowAlias(DeleteFlowAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlowVersionResult deleteFlowVersion(DeleteFlowVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteKnowledgeBaseResult deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePromptResult deletePrompt(DeletePromptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateAgentKnowledgeBaseResult disassociateAgentKnowledgeBase(DisassociateAgentKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAgentResult getAgent(GetAgentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAgentActionGroupResult getAgentActionGroup(GetAgentActionGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAgentAliasResult getAgentAlias(GetAgentAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAgentKnowledgeBaseResult getAgentKnowledgeBase(GetAgentKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAgentVersionResult getAgentVersion(GetAgentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDataSourceResult getDataSource(GetDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFlowResult getFlow(GetFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFlowAliasResult getFlowAlias(GetFlowAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFlowVersionResult getFlowVersion(GetFlowVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIngestionJobResult getIngestionJob(GetIngestionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetKnowledgeBaseResult getKnowledgeBase(GetKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPromptResult getPrompt(GetPromptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAgentActionGroupsResult listAgentActionGroups(ListAgentActionGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAgentAliasesResult listAgentAliases(ListAgentAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAgentKnowledgeBasesResult listAgentKnowledgeBases(ListAgentKnowledgeBasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAgentVersionsResult listAgentVersions(ListAgentVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAgentsResult listAgents(ListAgentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDataSourcesResult listDataSources(ListDataSourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlowAliasesResult listFlowAliases(ListFlowAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlowVersionsResult listFlowVersions(ListFlowVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlowsResult listFlows(ListFlowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIngestionJobsResult listIngestionJobs(ListIngestionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListKnowledgeBasesResult listKnowledgeBases(ListKnowledgeBasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPromptsResult listPrompts(ListPromptsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PrepareAgentResult prepareAgent(PrepareAgentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PrepareFlowResult prepareFlow(PrepareFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartIngestionJobResult startIngestionJob(StartIngestionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAgentResult updateAgent(UpdateAgentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAgentActionGroupResult updateAgentActionGroup(UpdateAgentActionGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAgentAliasResult updateAgentAlias(UpdateAgentAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAgentKnowledgeBaseResult updateAgentKnowledgeBase(UpdateAgentKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDataSourceResult updateDataSource(UpdateDataSourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFlowResult updateFlow(UpdateFlowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFlowAliasResult updateFlowAlias(UpdateFlowAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateKnowledgeBaseResult updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePromptResult updatePrompt(UpdatePromptRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
