/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.bedrock.model.EvaluationSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEvaluationJobsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<EvaluationSummary> jobSummaries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListEvaluationJobsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<EvaluationSummary> getJobSummaries() {
        return this.jobSummaries;
    }

    public void setJobSummaries(Collection<EvaluationSummary> jobSummaries) {
        if (jobSummaries == null) {
            this.jobSummaries = null;
            return;
        }
        this.jobSummaries = new ArrayList<EvaluationSummary>(jobSummaries);
    }

    public ListEvaluationJobsResult withJobSummaries(EvaluationSummary ... jobSummaries) {
        if (this.jobSummaries == null) {
            this.setJobSummaries(new ArrayList<EvaluationSummary>(jobSummaries.length));
        }
        for (EvaluationSummary ele : jobSummaries) {
            this.jobSummaries.add(ele);
        }
        return this;
    }

    public ListEvaluationJobsResult withJobSummaries(Collection<EvaluationSummary> jobSummaries) {
        this.setJobSummaries(jobSummaries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getJobSummaries() != null) {
            sb.append("JobSummaries: ").append(this.getJobSummaries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEvaluationJobsResult)) {
            return false;
        }
        ListEvaluationJobsResult other = (ListEvaluationJobsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getJobSummaries() == null ^ this.getJobSummaries() == null) {
            return false;
        }
        return other.getJobSummaries() == null || other.getJobSummaries().equals(this.getJobSummaries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getJobSummaries() == null ? 0 : this.getJobSummaries().hashCode());
        return hashCode;
    }

    public ListEvaluationJobsResult clone() {
        try {
            return (ListEvaluationJobsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

