/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.bedrock.AmazonBedrockAsync;
import com.amazonaws.services.bedrock.AmazonBedrockAsyncClientBuilder;
import com.amazonaws.services.bedrock.AmazonBedrockClient;
import com.amazonaws.services.bedrock.model.CreateModelCustomizationJobRequest;
import com.amazonaws.services.bedrock.model.CreateModelCustomizationJobResult;
import com.amazonaws.services.bedrock.model.CreateProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.CreateProvisionedModelThroughputResult;
import com.amazonaws.services.bedrock.model.DeleteCustomModelRequest;
import com.amazonaws.services.bedrock.model.DeleteCustomModelResult;
import com.amazonaws.services.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest;
import com.amazonaws.services.bedrock.model.DeleteModelInvocationLoggingConfigurationResult;
import com.amazonaws.services.bedrock.model.DeleteProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.DeleteProvisionedModelThroughputResult;
import com.amazonaws.services.bedrock.model.GetCustomModelRequest;
import com.amazonaws.services.bedrock.model.GetCustomModelResult;
import com.amazonaws.services.bedrock.model.GetFoundationModelRequest;
import com.amazonaws.services.bedrock.model.GetFoundationModelResult;
import com.amazonaws.services.bedrock.model.GetModelCustomizationJobRequest;
import com.amazonaws.services.bedrock.model.GetModelCustomizationJobResult;
import com.amazonaws.services.bedrock.model.GetModelInvocationLoggingConfigurationRequest;
import com.amazonaws.services.bedrock.model.GetModelInvocationLoggingConfigurationResult;
import com.amazonaws.services.bedrock.model.GetProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.GetProvisionedModelThroughputResult;
import com.amazonaws.services.bedrock.model.ListCustomModelsRequest;
import com.amazonaws.services.bedrock.model.ListCustomModelsResult;
import com.amazonaws.services.bedrock.model.ListFoundationModelsRequest;
import com.amazonaws.services.bedrock.model.ListFoundationModelsResult;
import com.amazonaws.services.bedrock.model.ListModelCustomizationJobsRequest;
import com.amazonaws.services.bedrock.model.ListModelCustomizationJobsResult;
import com.amazonaws.services.bedrock.model.ListProvisionedModelThroughputsRequest;
import com.amazonaws.services.bedrock.model.ListProvisionedModelThroughputsResult;
import com.amazonaws.services.bedrock.model.ListTagsForResourceRequest;
import com.amazonaws.services.bedrock.model.ListTagsForResourceResult;
import com.amazonaws.services.bedrock.model.PutModelInvocationLoggingConfigurationRequest;
import com.amazonaws.services.bedrock.model.PutModelInvocationLoggingConfigurationResult;
import com.amazonaws.services.bedrock.model.StopModelCustomizationJobRequest;
import com.amazonaws.services.bedrock.model.StopModelCustomizationJobResult;
import com.amazonaws.services.bedrock.model.TagResourceRequest;
import com.amazonaws.services.bedrock.model.TagResourceResult;
import com.amazonaws.services.bedrock.model.UntagResourceRequest;
import com.amazonaws.services.bedrock.model.UntagResourceResult;
import com.amazonaws.services.bedrock.model.UpdateProvisionedModelThroughputRequest;
import com.amazonaws.services.bedrock.model.UpdateProvisionedModelThroughputResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonBedrockAsyncClient
extends AmazonBedrockClient
implements AmazonBedrockAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonBedrockAsyncClientBuilder asyncBuilder() {
        return AmazonBedrockAsyncClientBuilder.standard();
    }

    AmazonBedrockAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonBedrockAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateModelCustomizationJobResult> createModelCustomizationJobAsync(CreateModelCustomizationJobRequest request) {
        return this.createModelCustomizationJobAsync(request, null);
    }

    @Override
    public Future<CreateModelCustomizationJobResult> createModelCustomizationJobAsync(CreateModelCustomizationJobRequest request, final AsyncHandler<CreateModelCustomizationJobRequest, CreateModelCustomizationJobResult> asyncHandler) {
        final CreateModelCustomizationJobRequest finalRequest = (CreateModelCustomizationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateModelCustomizationJobResult>(){

            @Override
            public CreateModelCustomizationJobResult call() throws Exception {
                CreateModelCustomizationJobResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeCreateModelCustomizationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProvisionedModelThroughputResult> createProvisionedModelThroughputAsync(CreateProvisionedModelThroughputRequest request) {
        return this.createProvisionedModelThroughputAsync(request, null);
    }

    @Override
    public Future<CreateProvisionedModelThroughputResult> createProvisionedModelThroughputAsync(CreateProvisionedModelThroughputRequest request, final AsyncHandler<CreateProvisionedModelThroughputRequest, CreateProvisionedModelThroughputResult> asyncHandler) {
        final CreateProvisionedModelThroughputRequest finalRequest = (CreateProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProvisionedModelThroughputResult>(){

            @Override
            public CreateProvisionedModelThroughputResult call() throws Exception {
                CreateProvisionedModelThroughputResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeCreateProvisionedModelThroughput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCustomModelResult> deleteCustomModelAsync(DeleteCustomModelRequest request) {
        return this.deleteCustomModelAsync(request, null);
    }

    @Override
    public Future<DeleteCustomModelResult> deleteCustomModelAsync(DeleteCustomModelRequest request, final AsyncHandler<DeleteCustomModelRequest, DeleteCustomModelResult> asyncHandler) {
        final DeleteCustomModelRequest finalRequest = (DeleteCustomModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCustomModelResult>(){

            @Override
            public DeleteCustomModelResult call() throws Exception {
                DeleteCustomModelResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeDeleteCustomModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteModelInvocationLoggingConfigurationResult> deleteModelInvocationLoggingConfigurationAsync(DeleteModelInvocationLoggingConfigurationRequest request) {
        return this.deleteModelInvocationLoggingConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteModelInvocationLoggingConfigurationResult> deleteModelInvocationLoggingConfigurationAsync(DeleteModelInvocationLoggingConfigurationRequest request, final AsyncHandler<DeleteModelInvocationLoggingConfigurationRequest, DeleteModelInvocationLoggingConfigurationResult> asyncHandler) {
        final DeleteModelInvocationLoggingConfigurationRequest finalRequest = (DeleteModelInvocationLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteModelInvocationLoggingConfigurationResult>(){

            @Override
            public DeleteModelInvocationLoggingConfigurationResult call() throws Exception {
                DeleteModelInvocationLoggingConfigurationResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeDeleteModelInvocationLoggingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProvisionedModelThroughputResult> deleteProvisionedModelThroughputAsync(DeleteProvisionedModelThroughputRequest request) {
        return this.deleteProvisionedModelThroughputAsync(request, null);
    }

    @Override
    public Future<DeleteProvisionedModelThroughputResult> deleteProvisionedModelThroughputAsync(DeleteProvisionedModelThroughputRequest request, final AsyncHandler<DeleteProvisionedModelThroughputRequest, DeleteProvisionedModelThroughputResult> asyncHandler) {
        final DeleteProvisionedModelThroughputRequest finalRequest = (DeleteProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProvisionedModelThroughputResult>(){

            @Override
            public DeleteProvisionedModelThroughputResult call() throws Exception {
                DeleteProvisionedModelThroughputResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeDeleteProvisionedModelThroughput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCustomModelResult> getCustomModelAsync(GetCustomModelRequest request) {
        return this.getCustomModelAsync(request, null);
    }

    @Override
    public Future<GetCustomModelResult> getCustomModelAsync(GetCustomModelRequest request, final AsyncHandler<GetCustomModelRequest, GetCustomModelResult> asyncHandler) {
        final GetCustomModelRequest finalRequest = (GetCustomModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCustomModelResult>(){

            @Override
            public GetCustomModelResult call() throws Exception {
                GetCustomModelResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeGetCustomModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFoundationModelResult> getFoundationModelAsync(GetFoundationModelRequest request) {
        return this.getFoundationModelAsync(request, null);
    }

    @Override
    public Future<GetFoundationModelResult> getFoundationModelAsync(GetFoundationModelRequest request, final AsyncHandler<GetFoundationModelRequest, GetFoundationModelResult> asyncHandler) {
        final GetFoundationModelRequest finalRequest = (GetFoundationModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFoundationModelResult>(){

            @Override
            public GetFoundationModelResult call() throws Exception {
                GetFoundationModelResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeGetFoundationModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetModelCustomizationJobResult> getModelCustomizationJobAsync(GetModelCustomizationJobRequest request) {
        return this.getModelCustomizationJobAsync(request, null);
    }

    @Override
    public Future<GetModelCustomizationJobResult> getModelCustomizationJobAsync(GetModelCustomizationJobRequest request, final AsyncHandler<GetModelCustomizationJobRequest, GetModelCustomizationJobResult> asyncHandler) {
        final GetModelCustomizationJobRequest finalRequest = (GetModelCustomizationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetModelCustomizationJobResult>(){

            @Override
            public GetModelCustomizationJobResult call() throws Exception {
                GetModelCustomizationJobResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeGetModelCustomizationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetModelInvocationLoggingConfigurationResult> getModelInvocationLoggingConfigurationAsync(GetModelInvocationLoggingConfigurationRequest request) {
        return this.getModelInvocationLoggingConfigurationAsync(request, null);
    }

    @Override
    public Future<GetModelInvocationLoggingConfigurationResult> getModelInvocationLoggingConfigurationAsync(GetModelInvocationLoggingConfigurationRequest request, final AsyncHandler<GetModelInvocationLoggingConfigurationRequest, GetModelInvocationLoggingConfigurationResult> asyncHandler) {
        final GetModelInvocationLoggingConfigurationRequest finalRequest = (GetModelInvocationLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetModelInvocationLoggingConfigurationResult>(){

            @Override
            public GetModelInvocationLoggingConfigurationResult call() throws Exception {
                GetModelInvocationLoggingConfigurationResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeGetModelInvocationLoggingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProvisionedModelThroughputResult> getProvisionedModelThroughputAsync(GetProvisionedModelThroughputRequest request) {
        return this.getProvisionedModelThroughputAsync(request, null);
    }

    @Override
    public Future<GetProvisionedModelThroughputResult> getProvisionedModelThroughputAsync(GetProvisionedModelThroughputRequest request, final AsyncHandler<GetProvisionedModelThroughputRequest, GetProvisionedModelThroughputResult> asyncHandler) {
        final GetProvisionedModelThroughputRequest finalRequest = (GetProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProvisionedModelThroughputResult>(){

            @Override
            public GetProvisionedModelThroughputResult call() throws Exception {
                GetProvisionedModelThroughputResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeGetProvisionedModelThroughput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCustomModelsResult> listCustomModelsAsync(ListCustomModelsRequest request) {
        return this.listCustomModelsAsync(request, null);
    }

    @Override
    public Future<ListCustomModelsResult> listCustomModelsAsync(ListCustomModelsRequest request, final AsyncHandler<ListCustomModelsRequest, ListCustomModelsResult> asyncHandler) {
        final ListCustomModelsRequest finalRequest = (ListCustomModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCustomModelsResult>(){

            @Override
            public ListCustomModelsResult call() throws Exception {
                ListCustomModelsResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeListCustomModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFoundationModelsResult> listFoundationModelsAsync(ListFoundationModelsRequest request) {
        return this.listFoundationModelsAsync(request, null);
    }

    @Override
    public Future<ListFoundationModelsResult> listFoundationModelsAsync(ListFoundationModelsRequest request, final AsyncHandler<ListFoundationModelsRequest, ListFoundationModelsResult> asyncHandler) {
        final ListFoundationModelsRequest finalRequest = (ListFoundationModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFoundationModelsResult>(){

            @Override
            public ListFoundationModelsResult call() throws Exception {
                ListFoundationModelsResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeListFoundationModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListModelCustomizationJobsResult> listModelCustomizationJobsAsync(ListModelCustomizationJobsRequest request) {
        return this.listModelCustomizationJobsAsync(request, null);
    }

    @Override
    public Future<ListModelCustomizationJobsResult> listModelCustomizationJobsAsync(ListModelCustomizationJobsRequest request, final AsyncHandler<ListModelCustomizationJobsRequest, ListModelCustomizationJobsResult> asyncHandler) {
        final ListModelCustomizationJobsRequest finalRequest = (ListModelCustomizationJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListModelCustomizationJobsResult>(){

            @Override
            public ListModelCustomizationJobsResult call() throws Exception {
                ListModelCustomizationJobsResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeListModelCustomizationJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProvisionedModelThroughputsResult> listProvisionedModelThroughputsAsync(ListProvisionedModelThroughputsRequest request) {
        return this.listProvisionedModelThroughputsAsync(request, null);
    }

    @Override
    public Future<ListProvisionedModelThroughputsResult> listProvisionedModelThroughputsAsync(ListProvisionedModelThroughputsRequest request, final AsyncHandler<ListProvisionedModelThroughputsRequest, ListProvisionedModelThroughputsResult> asyncHandler) {
        final ListProvisionedModelThroughputsRequest finalRequest = (ListProvisionedModelThroughputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProvisionedModelThroughputsResult>(){

            @Override
            public ListProvisionedModelThroughputsResult call() throws Exception {
                ListProvisionedModelThroughputsResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeListProvisionedModelThroughputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutModelInvocationLoggingConfigurationResult> putModelInvocationLoggingConfigurationAsync(PutModelInvocationLoggingConfigurationRequest request) {
        return this.putModelInvocationLoggingConfigurationAsync(request, null);
    }

    @Override
    public Future<PutModelInvocationLoggingConfigurationResult> putModelInvocationLoggingConfigurationAsync(PutModelInvocationLoggingConfigurationRequest request, final AsyncHandler<PutModelInvocationLoggingConfigurationRequest, PutModelInvocationLoggingConfigurationResult> asyncHandler) {
        final PutModelInvocationLoggingConfigurationRequest finalRequest = (PutModelInvocationLoggingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutModelInvocationLoggingConfigurationResult>(){

            @Override
            public PutModelInvocationLoggingConfigurationResult call() throws Exception {
                PutModelInvocationLoggingConfigurationResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executePutModelInvocationLoggingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopModelCustomizationJobResult> stopModelCustomizationJobAsync(StopModelCustomizationJobRequest request) {
        return this.stopModelCustomizationJobAsync(request, null);
    }

    @Override
    public Future<StopModelCustomizationJobResult> stopModelCustomizationJobAsync(StopModelCustomizationJobRequest request, final AsyncHandler<StopModelCustomizationJobRequest, StopModelCustomizationJobResult> asyncHandler) {
        final StopModelCustomizationJobRequest finalRequest = (StopModelCustomizationJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopModelCustomizationJobResult>(){

            @Override
            public StopModelCustomizationJobResult call() throws Exception {
                StopModelCustomizationJobResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeStopModelCustomizationJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProvisionedModelThroughputResult> updateProvisionedModelThroughputAsync(UpdateProvisionedModelThroughputRequest request) {
        return this.updateProvisionedModelThroughputAsync(request, null);
    }

    @Override
    public Future<UpdateProvisionedModelThroughputResult> updateProvisionedModelThroughputAsync(UpdateProvisionedModelThroughputRequest request, final AsyncHandler<UpdateProvisionedModelThroughputRequest, UpdateProvisionedModelThroughputResult> asyncHandler) {
        final UpdateProvisionedModelThroughputRequest finalRequest = (UpdateProvisionedModelThroughputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateProvisionedModelThroughputResult>(){

            @Override
            public UpdateProvisionedModelThroughputResult call() throws Exception {
                UpdateProvisionedModelThroughputResult result = null;
                try {
                    result = AmazonBedrockAsyncClient.this.executeUpdateProvisionedModelThroughput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

