/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model.transform;

import com.amazonaws.services.bedrock.model.CloudWatchConfig;
import com.amazonaws.services.bedrock.model.transform.S3ConfigJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class CloudWatchConfigJsonUnmarshaller
implements Unmarshaller<CloudWatchConfig, JsonUnmarshallerContext> {
    private static CloudWatchConfigJsonUnmarshaller instance;

    public CloudWatchConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        CloudWatchConfig cloudWatchConfig = new CloudWatchConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("largeDataDeliveryS3Config", targetDepth)) {
                    context.nextToken();
                    cloudWatchConfig.setLargeDataDeliveryS3Config(S3ConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("logGroupName", targetDepth)) {
                    context.nextToken();
                    cloudWatchConfig.setLogGroupName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    cloudWatchConfig.setRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return cloudWatchConfig;
    }

    public static CloudWatchConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CloudWatchConfigJsonUnmarshaller();
        }
        return instance;
    }
}

