/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.EksVolume;

@SdkInternalApi
public class EksVolumeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> HOSTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostPath").build();
    private static final MarshallingInfo<StructuredPojo> EMPTYDIR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("emptyDir").build();
    private static final MarshallingInfo<StructuredPojo> SECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secret").build();
    private static final EksVolumeMarshaller instance = new EksVolumeMarshaller();

    public static EksVolumeMarshaller getInstance() {
        return instance;
    }

    public void marshall(EksVolume eksVolume, ProtocolMarshaller protocolMarshaller) {
        if (eksVolume == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eksVolume.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)eksVolume.getHostPath(), HOSTPATH_BINDING);
            protocolMarshaller.marshall((Object)eksVolume.getEmptyDir(), EMPTYDIR_BINDING);
            protocolMarshaller.marshall((Object)eksVolume.getSecret(), SECRET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

